"use strict";
/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
exports.__esModule = true;
exports.createAuthProviderFromConfig = void 0;
var authentication_1 = require("./authentication");
function createAuthProviderFromConfig(config, oauth2) {
    var authConfig = {
        oauth2: config.clientCredentialsAuthCredentials &&
            (0, authentication_1.requestAuthenticationProvider)(config.clientCredentialsAuthCredentials.oAuthToken, oauth2TokenProvider(oauth2, config.clientCredentialsAuthCredentials.oAuthTokenProvider), config.clientCredentialsAuthCredentials.oAuthOnTokenUpdate, {
                clockSkew: config.clientCredentialsAuthCredentials.oAuthClockSkew
            })
    };
    return (0, authentication_1.compositeAuthenticationProvider)(authConfig);
}
exports.createAuthProviderFromConfig = createAuthProviderFromConfig;
function oauth2TokenProvider(oauth2, defaultProvider) {
    return function (token) {
        var manager = oauth2();
        if (defaultProvider === undefined) {
            return manager.updateToken(token);
        }
        return defaultProvider(token, manager);
    };
}
//# sourceMappingURL=authProvider.js.map