"use strict";
/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
exports.__esModule = true;
exports.ClientCredentialsAuthManager = void 0;
var tslib_1 = require("tslib");
var authentication_1 = require("./authentication");
var oAuthAuthorizationController_1 = require("./controllers/oAuthAuthorizationController");
var ClientCredentialsAuthManager = /** @class */ (function () {
    function ClientCredentialsAuthManager(_a, client) {
        var oAuthClientId = _a.oAuthClientId, oAuthClientSecret = _a.oAuthClientSecret, oAuthClockSkew = _a.oAuthClockSkew;
        this._oAuthClientId = oAuthClientId;
        this._oAuthClientSecret = oAuthClientSecret;
        this._oAuthClockSkew = oAuthClockSkew;
        this._oAuthController = new oAuthAuthorizationController_1.OAuthAuthorizationController(client);
    }
    ClientCredentialsAuthManager.prototype.updateToken = function (oAuthToken) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(!this.isValid(oAuthToken) || this.isExpired(oAuthToken))) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.fetchToken()];
                    case 1:
                        oAuthToken = _a.sent();
                        _a.label = 2;
                    case 2: return [2 /*return*/, oAuthToken];
                }
            });
        });
    };
    ClientCredentialsAuthManager.prototype.isValid = function (oAuthToken) {
        return (0, authentication_1.isValid)(oAuthToken);
    };
    ClientCredentialsAuthManager.prototype.isExpired = function (oAuthToken) {
        return (0, authentication_1.isExpired)(oAuthToken, this._oAuthClockSkew);
    };
    ClientCredentialsAuthManager.prototype.fetchToken = function (additionalParams) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var authorization, result;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        authorization = this.getClientBasicAuth(this._oAuthClientId, this._oAuthClientSecret);
                        return [4 /*yield*/, this._oAuthController.requestToken({
                                authorization: authorization,
                                scope: undefined
                            }, additionalParams)];
                    case 1:
                        result = (_a.sent()).result;
                        return [2 /*return*/, this.setExpiry(result)];
                }
            });
        });
    };
    ClientCredentialsAuthManager.prototype.getClientBasicAuth = function (clientId, clientSecret) {
        return "Basic ".concat(Buffer.from(clientId + ':' + clientSecret).toString('base64'));
    };
    ClientCredentialsAuthManager.prototype.setExpiry = function (token) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var newToken;
            return tslib_1.__generator(this, function (_a) {
                newToken = token;
                if (newToken.expiresIn) {
                    newToken.expiry =
                        BigInt(Math.round(Date.now() / 1000)) + newToken.expiresIn;
                }
                return [2 /*return*/, newToken];
            });
        });
    };
    return ClientCredentialsAuthManager;
}());
exports.ClientCredentialsAuthManager = ClientCredentialsAuthManager;
//# sourceMappingURL=clientCredentialsAuthManager.js.map