"use strict";
/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
exports.__esModule = true;
exports.PaymentsController = void 0;
var tslib_1 = require("tslib");
var capturedPayment_1 = require("../models/capturedPayment");
var captureRequest_1 = require("../models/captureRequest");
var paymentAuthorization_1 = require("../models/paymentAuthorization");
var reauthorizeRequest_1 = require("../models/reauthorizeRequest");
var refund_1 = require("../models/refund");
var refundRequest_1 = require("../models/refundRequest");
var schema_1 = require("../schema");
var baseController_1 = require("./baseController");
var core_1 = require("@apimatic/core");
var customError_1 = require("../errors/customError");
var PaymentsController = /** @class */ (function (_super) {
    tslib_1.__extends(PaymentsController, _super);
    function PaymentsController() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Captures an authorized payment, by ID.
     *
     * @param authorizationId       The PayPal-generated ID for the authorized payment to
     *                                                       capture.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative
     *                                                       testing in the sandbox. This header configures the sandbox
     *                                                       into a negative testing state for transactions that include
     *                                                       the merchant.
     * @param paypalRequestId       The server stores keys for 45 days.
     * @param prefer                The preferred server response upon successful completion of
     *                                                       the request. Value is: return=minimal. The server returns a
     *                                                       minimal response to optimize communication between the API
     *                                                       caller and the server. A minimal response includes the id,
     *                                                       status and HATEOAS links. return=representation. The server
     *                                                       returns a complete resource representation, including the
     *                                                       current state of the resource.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that
     *                                                       identifies the merchant. For details, see [PayPal-Auth-
     *                                                       Assertion](/docs/api/reference/api-requests/#paypal-auth-
     *                                                       assertion). Note:For three party transactions in which a
     *                                                       partner is managing the API calls on behalf of a merchant,
     *                                                       the partner must identify the merchant using either a PayPal-
     *                                                       Auth-Assertion header or an access token with target_subject.
     * @param body
     * @return Response from the API call
     */
    PaymentsController.prototype.captureAuthorizedPayment = function (_a, requestOptions) {
        var authorizationId = _a.authorizationId, paypalMockResponse = _a.paypalMockResponse, paypalRequestId = _a.paypalRequestId, prefer = _a.prefer, paypalAuthAssertion = _a.paypalAuthAssertion, body = _a.body;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('POST');
                mapped = req.prepareArgs({
                    authorizationId: [authorizationId, (0, schema_1.string)()],
                    paypalMockResponse: [paypalMockResponse, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalRequestId: [paypalRequestId, (0, schema_1.optional)((0, schema_1.string)())],
                    prefer: [prefer, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())],
                    body: [body, (0, schema_1.optional)(captureRequest_1.captureRequestSchema)]
                });
                req.header('Content-Type', 'application/json');
                req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
                req.header('PayPal-Request-Id', mapped.paypalRequestId);
                req.header('Prefer', mapped.prefer);
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.json(mapped.body);
                req.appendTemplatePath(templateObject_1 || (templateObject_1 = tslib_1.__makeTemplateObject(["/v2/payments/authorizations/", "/capture"], ["/v2/payments/authorizations/", "/capture"])), mapped.authorizationId);
                req.throwOn(400, customError_1.CustomError, 'The request failed because it is not well-formed or is syntactically incorrect or violates schema.');
                req.throwOn(401, customError_1.CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
                req.throwOn(403, customError_1.CustomError, 'The request failed because the caller has insufficient permissions.');
                req.throwOn(404, customError_1.CustomError, 'The request failed because the resource does not exist.');
                req.throwOn(409, customError_1.CustomError, 'The server has detected a conflict while processing this request.');
                req.throwOn(422, customError_1.CustomError, 'The request failed because it is semantically incorrect or failed business validation.');
                req.throwOn(500, core_1.ApiError, 'The request failed because an internal server error occurred.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(capturedPayment_1.capturedPaymentSchema, requestOptions)];
            });
        });
    };
    /**
     * Shows details for a captured payment, by ID.
     *
     * @param captureId            The PayPal-generated ID for the captured payment for which to show details.
     * @param paypalMockResponse   PayPal's REST API uses a request header to invoke negative testing in the
     *                                       sandbox. This header configures the sandbox into a negative testing state
     *                                       for transactions that include the merchant.
     * @return Response from the API call
     */
    PaymentsController.prototype.getCapturedPayment = function (_a, requestOptions) {
        var captureId = _a.captureId, paypalMockResponse = _a.paypalMockResponse;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('GET');
                mapped = req.prepareArgs({
                    captureId: [captureId, (0, schema_1.string)()],
                    paypalMockResponse: [paypalMockResponse, (0, schema_1.optional)((0, schema_1.string)())]
                });
                req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
                req.appendTemplatePath(templateObject_2 || (templateObject_2 = tslib_1.__makeTemplateObject(["/v2/payments/captures/", ""], ["/v2/payments/captures/", ""])), mapped.captureId);
                req.throwOn(401, customError_1.CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
                req.throwOn(403, customError_1.CustomError, 'The request failed because the caller has insufficient permissions.');
                req.throwOn(404, customError_1.CustomError, 'The request failed because the resource does not exist.');
                req.throwOn(500, core_1.ApiError, 'The request failed because an internal server error occurred.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(capturedPayment_1.capturedPaymentSchema, requestOptions)];
            });
        });
    };
    /**
     * Reauthorizes an authorized PayPal account payment, by ID. To ensure that funds are still available,
     * reauthorize a payment after its initial three-day honor period expires. Within the 29-day
     * authorization period, you can issue multiple re-authorizations after the honor period expires. If 30
     * days have transpired since the date of the original authorization, you must create an authorized
     * payment instead of reauthorizing the original authorized payment. A reauthorized payment itself has
     * a new honor period of three days. You can reauthorize an authorized payment from 4 to 29 days after
     * the 3-day honor period. The allowed amount depends on context and geography, for example in US it is
     * up to 115% of the original authorized amount, not to exceed an increase of $75 USD. Supports only
     * the `amount` request parameter. Note: This request is currently not supported for Partner use cases.
     *
     * @param authorizationId       The PayPal-generated ID for the authorized payment to
     *                                                           reauthorize.
     * @param paypalRequestId       The server stores keys for 45 days.
     * @param prefer                The preferred server response upon successful
     *                                                           completion of the request. Value is: return=minimal. The
     *                                                           server returns a minimal response to optimize
     *                                                           communication between the API caller and the server. A
     *                                                           minimal response includes the id, status and HATEOAS
     *                                                           links. return=representation. The server returns a
     *                                                           complete resource representation, including the current
     *                                                           state of the resource.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion
     *                                                           that identifies the merchant. For details, see [PayPal-
     *                                                           Auth-Assertion](/docs/api/reference/api-requests/#paypal-
     *                                                           auth-assertion). Note:For three party transactions in
     *                                                           which a partner is managing the API calls on behalf of a
     *                                                           merchant, the partner must identify the merchant using
     *                                                           either a PayPal-Auth-Assertion header or an access token
     *                                                           with target_subject.
     * @param body
     * @return Response from the API call
     */
    PaymentsController.prototype.reauthorizePayment = function (_a, requestOptions) {
        var authorizationId = _a.authorizationId, paypalRequestId = _a.paypalRequestId, prefer = _a.prefer, paypalAuthAssertion = _a.paypalAuthAssertion, body = _a.body;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('POST');
                mapped = req.prepareArgs({
                    authorizationId: [authorizationId, (0, schema_1.string)()],
                    paypalRequestId: [paypalRequestId, (0, schema_1.optional)((0, schema_1.string)())],
                    prefer: [prefer, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())],
                    body: [body, (0, schema_1.optional)(reauthorizeRequest_1.reauthorizeRequestSchema)]
                });
                req.header('Content-Type', 'application/json');
                req.header('PayPal-Request-Id', mapped.paypalRequestId);
                req.header('Prefer', mapped.prefer);
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.json(mapped.body);
                req.appendTemplatePath(templateObject_3 || (templateObject_3 = tslib_1.__makeTemplateObject(["/v2/payments/authorizations/", "/reauthorize"], ["/v2/payments/authorizations/", "/reauthorize"])), mapped.authorizationId);
                req.throwOn(400, customError_1.CustomError, 'The request failed because it is not well-formed or is syntactically incorrect or violates schema.');
                req.throwOn(401, customError_1.CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
                req.throwOn(404, customError_1.CustomError, 'The request failed because the resource does not exist.');
                req.throwOn(422, customError_1.CustomError, 'The request failed because it either is semantically incorrect or failed business validation.');
                req.throwOn(500, core_1.ApiError, 'The request failed because an internal server error occurred.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(paymentAuthorization_1.paymentAuthorizationSchema, requestOptions)];
            });
        });
    };
    /**
     * Voids, or cancels, an authorized payment, by ID. You cannot void an authorized payment that has been
     * fully captured.
     *
     * @param authorizationId       The PayPal-generated ID for the authorized payment to void.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative testing in the
     *                                        sandbox. This header configures the sandbox into a negative testing state
     *                                        for transactions that include the merchant.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that identifies the
     *                                        merchant. For details, see [PayPal-Auth-Assertion](/docs/api/reference/api-
     *                                        requests/#paypal-auth-assertion). Note:For three party transactions in
     *                                        which a partner is managing the API calls on behalf of a merchant, the
     *                                        partner must identify the merchant using either a PayPal-Auth-Assertion
     *                                        header or an access token with target_subject.
     * @param paypalRequestId       The server stores keys for 45 days.
     * @param prefer                The preferred server response upon successful completion of the request.
     *                                        Value is: return=minimal. The server returns a minimal response to optimize
     *                                        communication between the API caller and the server. A minimal response
     *                                        includes the id, status and HATEOAS links. return=representation. The
     *                                        server returns a complete resource representation, including the current
     *                                        state of the resource.
     * @return Response from the API call
     */
    PaymentsController.prototype.voidPayment = function (_a, requestOptions) {
        var authorizationId = _a.authorizationId, paypalMockResponse = _a.paypalMockResponse, paypalAuthAssertion = _a.paypalAuthAssertion, paypalRequestId = _a.paypalRequestId, prefer = _a.prefer;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('POST');
                mapped = req.prepareArgs({
                    authorizationId: [authorizationId, (0, schema_1.string)()],
                    paypalMockResponse: [paypalMockResponse, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalRequestId: [paypalRequestId, (0, schema_1.optional)((0, schema_1.string)())],
                    prefer: [prefer, (0, schema_1.optional)((0, schema_1.string)())]
                });
                req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.header('PayPal-Request-Id', mapped.paypalRequestId);
                req.header('Prefer', mapped.prefer);
                req.appendTemplatePath(templateObject_4 || (templateObject_4 = tslib_1.__makeTemplateObject(["/v2/payments/authorizations/", "/void"], ["/v2/payments/authorizations/", "/void"])), mapped.authorizationId);
                req.throwOn(401, customError_1.CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
                req.throwOn(403, customError_1.CustomError, 'The request failed because the caller has insufficient permissions.');
                req.throwOn(404, customError_1.CustomError, 'The request failed because the resource does not exist.');
                req.throwOn(409, customError_1.CustomError, 'The request failed because a previous call for the given resource is in progress.');
                req.throwOn(422, customError_1.CustomError, 'The request failed because it either is semantically incorrect or failed business validation.');
                req.throwOn(500, core_1.ApiError, 'The request failed because an internal server error occurred.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson((0, schema_1.nullable)(paymentAuthorization_1.paymentAuthorizationSchema), requestOptions)];
            });
        });
    };
    /**
     * Refunds a captured payment, by ID. For a full refund, include an empty payload in the JSON request
     * body. For a partial refund, include an amount object in the JSON request body.
     *
     * @param captureId             The PayPal-generated ID for the captured payment to refund.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative
     *                                                      testing in the sandbox. This header configures the sandbox
     *                                                      into a negative testing state for transactions that include
     *                                                      the merchant.
     * @param paypalRequestId       The server stores keys for 45 days.
     * @param prefer                The preferred server response upon successful completion of
     *                                                      the request. Value is: return=minimal. The server returns a
     *                                                      minimal response to optimize communication between the API
     *                                                      caller and the server. A minimal response includes the id,
     *                                                      status and HATEOAS links. return=representation. The server
     *                                                      returns a complete resource representation, including the
     *                                                      current state of the resource.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that
     *                                                      identifies the merchant. For details, see [PayPal-Auth-
     *                                                      Assertion](/docs/api/reference/api-requests/#paypal-auth-
     *                                                      assertion). Note:For three party transactions in which a
     *                                                      partner is managing the API calls on behalf of a merchant,
     *                                                      the partner must identify the merchant using either a PayPal-
     *                                                      Auth-Assertion header or an access token with target_subject.
     * @param body
     * @return Response from the API call
     */
    PaymentsController.prototype.refundCapturedPayment = function (_a, requestOptions) {
        var captureId = _a.captureId, paypalMockResponse = _a.paypalMockResponse, paypalRequestId = _a.paypalRequestId, prefer = _a.prefer, paypalAuthAssertion = _a.paypalAuthAssertion, body = _a.body;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('POST');
                mapped = req.prepareArgs({
                    captureId: [captureId, (0, schema_1.string)()],
                    paypalMockResponse: [paypalMockResponse, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalRequestId: [paypalRequestId, (0, schema_1.optional)((0, schema_1.string)())],
                    prefer: [prefer, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())],
                    body: [body, (0, schema_1.optional)(refundRequest_1.refundRequestSchema)]
                });
                req.header('Content-Type', 'application/json');
                req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
                req.header('PayPal-Request-Id', mapped.paypalRequestId);
                req.header('Prefer', mapped.prefer);
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.json(mapped.body);
                req.appendTemplatePath(templateObject_5 || (templateObject_5 = tslib_1.__makeTemplateObject(["/v2/payments/captures/", "/refund"], ["/v2/payments/captures/", "/refund"])), mapped.captureId);
                req.throwOn(400, customError_1.CustomError, 'The request failed because it is not well-formed or is syntactically incorrect or violates schema.');
                req.throwOn(401, customError_1.CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
                req.throwOn(403, customError_1.CustomError, 'The request failed because the caller has insufficient permissions.');
                req.throwOn(404, customError_1.CustomError, 'The request failed because the resource does not exist.');
                req.throwOn(409, customError_1.CustomError, 'The request failed because a previous call for the given resource is in progress.');
                req.throwOn(422, customError_1.CustomError, 'The request failed because it either is semantically incorrect or failed business validation.');
                req.throwOn(500, core_1.ApiError, 'The request failed because an internal server error occurred.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(refund_1.refundSchema, requestOptions)];
            });
        });
    };
    /**
     * Shows details for an authorized payment, by ID.
     *
     * @param authorizationId       The ID of the authorized payment for which to show details.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative testing in the
     *                                        sandbox. This header configures the sandbox into a negative testing state
     *                                        for transactions that include the merchant.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that identifies the
     *                                        merchant. For details, see [PayPal-Auth-Assertion](/docs/api/reference/api-
     *                                        requests/#paypal-auth-assertion). Note:For three party transactions in
     *                                        which a partner is managing the API calls on behalf of a merchant, the
     *                                        partner must identify the merchant using either a PayPal-Auth-Assertion
     *                                        header or an access token with target_subject.
     * @return Response from the API call
     */
    PaymentsController.prototype.getAuthorizedPayment = function (_a, requestOptions) {
        var authorizationId = _a.authorizationId, paypalMockResponse = _a.paypalMockResponse, paypalAuthAssertion = _a.paypalAuthAssertion;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('GET');
                mapped = req.prepareArgs({
                    authorizationId: [authorizationId, (0, schema_1.string)()],
                    paypalMockResponse: [paypalMockResponse, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())]
                });
                req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.appendTemplatePath(templateObject_6 || (templateObject_6 = tslib_1.__makeTemplateObject(["/v2/payments/authorizations/", ""], ["/v2/payments/authorizations/", ""])), mapped.authorizationId);
                req.throwOn(401, customError_1.CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
                req.throwOn(404, customError_1.CustomError, 'The request failed because the resource does not exist.');
                req.throwOn(500, core_1.ApiError, 'The request failed because an internal server error occurred.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(paymentAuthorization_1.paymentAuthorizationSchema, requestOptions)];
            });
        });
    };
    /**
     * Shows details for a refund, by ID.
     *
     * @param refundId              The PayPal-generated ID for the refund for which to show details.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative testing in the
     *                                        sandbox. This header configures the sandbox into a negative testing state
     *                                        for transactions that include the merchant.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that identifies the
     *                                        merchant. For details, see [PayPal-Auth-Assertion](/docs/api/reference/api-
     *                                        requests/#paypal-auth-assertion). Note:For three party transactions in
     *                                        which a partner is managing the API calls on behalf of a merchant, the
     *                                        partner must identify the merchant using either a PayPal-Auth-Assertion
     *                                        header or an access token with target_subject.
     * @return Response from the API call
     */
    PaymentsController.prototype.getRefund = function (_a, requestOptions) {
        var refundId = _a.refundId, paypalMockResponse = _a.paypalMockResponse, paypalAuthAssertion = _a.paypalAuthAssertion;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('GET');
                mapped = req.prepareArgs({
                    refundId: [refundId, (0, schema_1.string)()],
                    paypalMockResponse: [paypalMockResponse, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())]
                });
                req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.appendTemplatePath(templateObject_7 || (templateObject_7 = tslib_1.__makeTemplateObject(["/v2/payments/refunds/", ""], ["/v2/payments/refunds/", ""])), mapped.refundId);
                req.throwOn(401, customError_1.CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
                req.throwOn(403, customError_1.CustomError, 'The request failed because the caller has insufficient permissions.');
                req.throwOn(404, customError_1.CustomError, 'The request failed because the resource does not exist.');
                req.throwOn(500, core_1.ApiError, 'The request failed because an internal server error occurred.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(refund_1.refundSchema, requestOptions)];
            });
        });
    };
    return PaymentsController;
}(baseController_1.BaseController));
exports.PaymentsController = PaymentsController;
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5, templateObject_6, templateObject_7;
//# sourceMappingURL=paymentsController.js.map