"use strict";
/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
exports.__esModule = true;
exports.VaultController = void 0;
var tslib_1 = require("tslib");
var customerVaultPaymentTokensResponse_1 = require("../models/customerVaultPaymentTokensResponse");
var paymentTokenRequest_1 = require("../models/paymentTokenRequest");
var paymentTokenResponse_1 = require("../models/paymentTokenResponse");
var setupTokenRequest_1 = require("../models/setupTokenRequest");
var setupTokenResponse_1 = require("../models/setupTokenResponse");
var schema_1 = require("../schema");
var baseController_1 = require("./baseController");
var customError_1 = require("../errors/customError");
var VaultController = /** @class */ (function (_super) {
    tslib_1.__extends(VaultController, _super);
    function VaultController() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Delete the payment token associated with the payment token id.
     *
     * @param id ID of the payment token.
     * @return Response from the API call
     */
    VaultController.prototype.deletePaymentToken = function (id, requestOptions) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_a) {
                req = this.createRequest('DELETE');
                mapped = req.prepareArgs({ id: [id, (0, schema_1.string)()] });
                req.appendTemplatePath(templateObject_1 || (templateObject_1 = tslib_1.__makeTemplateObject(["/v3/vault/payment-tokens/", ""], ["/v3/vault/payment-tokens/", ""])), mapped.id);
                req.throwOn(400, customError_1.CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
                req.throwOn(403, customError_1.CustomError, 'Authorization failed due to insufficient permissions.');
                req.throwOn(500, customError_1.CustomError, 'An internal server error has occurred.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.call(requestOptions)];
            });
        });
    };
    /**
     * Creates a Setup Token from the given payment source and adds it to the Vault of the associated
     * customer.
     *
     * @param body              Setup Token creation with a instrument type optional
     *                                                      financial instrument details and customer_id.
     * @param paypalRequestId   The server stores keys for 3 hours.
     * @return Response from the API call
     */
    VaultController.prototype.createSetupToken = function (_a, requestOptions) {
        var body = _a.body, paypalRequestId = _a.paypalRequestId;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('POST', '/v3/vault/setup-tokens');
                mapped = req.prepareArgs({
                    body: [body, setupTokenRequest_1.setupTokenRequestSchema],
                    paypalRequestId: [paypalRequestId, (0, schema_1.optional)((0, schema_1.string)())]
                });
                req.header('Content-Type', 'application/json');
                req.header('PayPal-Request-Id', mapped.paypalRequestId);
                req.json(mapped.body);
                req.throwOn(400, customError_1.CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
                req.throwOn(403, customError_1.CustomError, 'Authorization failed due to insufficient permissions.');
                req.throwOn(422, customError_1.CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
                req.throwOn(500, customError_1.CustomError, 'An internal server error has occurred.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(setupTokenResponse_1.setupTokenResponseSchema, requestOptions)];
            });
        });
    };
    /**
     * Returns a readable representation of temporarily vaulted payment source associated with the setup
     * token id.
     *
     * @param id ID of the setup token.
     * @return Response from the API call
     */
    VaultController.prototype.getSetupToken = function (id, requestOptions) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_a) {
                req = this.createRequest('GET');
                mapped = req.prepareArgs({ id: [id, (0, schema_1.string)()] });
                req.appendTemplatePath(templateObject_2 || (templateObject_2 = tslib_1.__makeTemplateObject(["/v3/vault/setup-tokens/", ""], ["/v3/vault/setup-tokens/", ""])), mapped.id);
                req.throwOn(403, customError_1.CustomError, 'Authorization failed due to insufficient permissions.');
                req.throwOn(404, customError_1.CustomError, 'The specified resource does not exist.');
                req.throwOn(422, customError_1.CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
                req.throwOn(500, customError_1.CustomError, 'An internal server error has occurred.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(setupTokenResponse_1.setupTokenResponseSchema, requestOptions)];
            });
        });
    };
    /**
     * Creates a Payment Token from the given payment source and adds it to the Vault of the associated
     * customer.
     *
     * @param body              Payment Token creation with a financial instrument and an
     *                                                        optional customer_id.
     * @param paypalRequestId   The server stores keys for 3 hours.
     * @return Response from the API call
     */
    VaultController.prototype.createPaymentToken = function (_a, requestOptions) {
        var body = _a.body, paypalRequestId = _a.paypalRequestId;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('POST', '/v3/vault/payment-tokens');
                mapped = req.prepareArgs({
                    body: [body, paymentTokenRequest_1.paymentTokenRequestSchema],
                    paypalRequestId: [paypalRequestId, (0, schema_1.optional)((0, schema_1.string)())]
                });
                req.header('Content-Type', 'application/json');
                req.header('PayPal-Request-Id', mapped.paypalRequestId);
                req.json(mapped.body);
                req.throwOn(400, customError_1.CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
                req.throwOn(403, customError_1.CustomError, 'Authorization failed due to insufficient permissions.');
                req.throwOn(404, customError_1.CustomError, 'Request contains reference to resources that do not exist.');
                req.throwOn(422, customError_1.CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
                req.throwOn(500, customError_1.CustomError, 'An internal server error has occurred.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(paymentTokenResponse_1.paymentTokenResponseSchema, requestOptions)];
            });
        });
    };
    /**
     * Returns all payment tokens for a customer.
     *
     * @param customerId     A unique identifier representing a specific customer in merchant's/partner's
     *                                  system or records.
     * @param pageSize       A non-negative, non-zero integer indicating the maximum number of results to
     *                                  return at one time.
     * @param page           A non-negative, non-zero integer representing the page of the results.
     * @param totalRequired  A boolean indicating total number of items (total_items) and pages (total_pages)
     *                                  are expected to be returned in the response.
     * @return Response from the API call
     */
    VaultController.prototype.listCustomerPaymentTokens = function (_a, requestOptions) {
        var customerId = _a.customerId, pageSize = _a.pageSize, page = _a.page, totalRequired = _a.totalRequired;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('GET', '/v3/vault/payment-tokens');
                mapped = req.prepareArgs({
                    customerId: [customerId, (0, schema_1.string)()],
                    pageSize: [pageSize, (0, schema_1.optional)((0, schema_1.number)())],
                    page: [page, (0, schema_1.optional)((0, schema_1.number)())],
                    totalRequired: [totalRequired, (0, schema_1.optional)((0, schema_1.boolean)())]
                });
                req.query('customer_id', mapped.customerId);
                req.query('page_size', mapped.pageSize);
                req.query('page', mapped.page);
                req.query('total_required', mapped.totalRequired);
                req.throwOn(400, customError_1.CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
                req.throwOn(403, customError_1.CustomError, 'Authorization failed due to insufficient permissions.');
                req.throwOn(500, customError_1.CustomError, 'An internal server error has occurred.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(customerVaultPaymentTokensResponse_1.customerVaultPaymentTokensResponseSchema, requestOptions)];
            });
        });
    };
    /**
     * Returns a readable representation of vaulted payment source associated with the payment token id.
     *
     * @param id ID of the payment token.
     * @return Response from the API call
     */
    VaultController.prototype.getPaymentToken = function (id, requestOptions) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_a) {
                req = this.createRequest('GET');
                mapped = req.prepareArgs({ id: [id, (0, schema_1.string)()] });
                req.appendTemplatePath(templateObject_3 || (templateObject_3 = tslib_1.__makeTemplateObject(["/v3/vault/payment-tokens/", ""], ["/v3/vault/payment-tokens/", ""])), mapped.id);
                req.throwOn(403, customError_1.CustomError, 'Authorization failed due to insufficient permissions.');
                req.throwOn(404, customError_1.CustomError, 'The specified resource does not exist.');
                req.throwOn(422, customError_1.CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
                req.throwOn(500, customError_1.CustomError, 'An internal server error has occurred.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(paymentTokenResponse_1.paymentTokenResponseSchema, requestOptions)];
            });
        });
    };
    return VaultController;
}(baseController_1.BaseController));
exports.VaultController = VaultController;
var templateObject_1, templateObject_2, templateObject_3;
//# sourceMappingURL=vaultController.js.map