/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { compositeAuthenticationProvider, requestAuthenticationProvider, } from './authentication';
export function createAuthProviderFromConfig(config, oauth2) {
    const authConfig = {
        oauth2: config.clientCredentialsAuthCredentials &&
            requestAuthenticationProvider(config.clientCredentialsAuthCredentials.oAuthToken, oauth2TokenProvider(oauth2, config.clientCredentialsAuthCredentials.oAuthTokenProvider), config.clientCredentialsAuthCredentials.oAuthOnTokenUpdate, {
                clockSkew: config.clientCredentialsAuthCredentials.oAuthClockSkew,
            }),
    };
    return compositeAuthenticationProvider(authConfig);
}
function oauth2TokenProvider(oauth2, defaultProvider) {
    return (token) => {
        const manager = oauth2();
        if (defaultProvider === undefined) {
            return manager.updateToken(token);
        }
        return defaultProvider(token, manager);
    };
}
//# sourceMappingURL=authProvider.js.map