/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { createAuthProviderFromConfig } from './authProvider';
import { ClientCredentialsAuthManager } from './clientCredentialsAuthManager';
import { Environment } from './configuration';
import { DEFAULT_CONFIGURATION, DEFAULT_RETRY_CONFIG, DEFAULT_LOGGING_OPTIONS, } from './defaultConfiguration';
import { ApiLogger, mergeLoggingOptions } from './core';
import { ApiError } from './core';
import { setHeader } from './core';
import { updateUserAgent } from './core';
import { AbortError, createRequestBuilderFactory, } from './core';
import { HttpClient } from './clientAdapter';
export class Client {
    constructor(config) {
        var _a, _b, _c, _d, _e, _f;
        this._config = Object.assign(Object.assign({}, DEFAULT_CONFIGURATION), config);
        this._retryConfig = Object.assign(Object.assign({}, DEFAULT_RETRY_CONFIG), (_a = this._config.httpClientOptions) === null || _a === void 0 ? void 0 : _a.retryConfig);
        this._loggingOp = this._config.logging
            ? mergeLoggingOptions((_b = this._config.logging) !== null && _b !== void 0 ? _b : {})
            : mergeLoggingOptions((_c = this._config.logging) !== null && _c !== void 0 ? _c : {}, DEFAULT_LOGGING_OPTIONS);
        this._timeout =
            typeof ((_d = this._config.httpClientOptions) === null || _d === void 0 ? void 0 : _d.timeout) != 'undefined'
                ? this._config.httpClientOptions.timeout
                : this._config.timeout;
        const clonedConfig = Object.assign(Object.assign({}, this._config), { clientCredentialsAuthCredentials: this._config
                .clientCredentialsAuthCredentials || {
                oAuthClientId: '',
                oAuthClientSecret: '',
            } });
        this._userAgent = updateUserAgent('PayPal REST API TypeScript SDK, Version: 1.1.0, on OS {os-info}');
        this._requestBuilderFactory = createRequestHandlerFactory((server) => getBaseUri(server, this._config), createAuthProviderFromConfig(this._config, () => this.clientCredentialsAuthManager), new HttpClient(AbortError, {
            timeout: this._timeout,
            clientConfigOverrides: this._config.unstable_httpClientOptions,
            httpAgent: (_e = this._config.httpClientOptions) === null || _e === void 0 ? void 0 : _e.httpAgent,
            httpsAgent: (_f = this._config.httpClientOptions) === null || _f === void 0 ? void 0 : _f.httpsAgent,
        }), [
            withErrorHandlers,
            withUserAgent(this._userAgent),
            withAuthenticationByDefault,
        ], this._retryConfig, this._loggingOp);
        this.clientCredentialsAuthManager = new ClientCredentialsAuthManager(clonedConfig.clientCredentialsAuthCredentials, this);
    }
    getRequestBuilderFactory() {
        return this._requestBuilderFactory;
    }
    /**
     * Clone this client and override given configuration options
     */
    withConfiguration(config) {
        return new Client(Object.assign(Object.assign({}, this._config), config));
    }
}
function createHttpClientAdapter(client) {
    return async (request, requestOptions) => {
        return await client.executeRequest(request, requestOptions);
    };
}
function getBaseUri(server = 'default', config) {
    if (config.environment === Environment.Production) {
        if (server === 'default') {
            return 'https://api-m.paypal.com';
        }
    }
    if (config.environment === Environment.Sandbox) {
        if (server === 'default') {
            return 'https://api-m.sandbox.paypal.com';
        }
    }
    throw new Error('Could not get Base URL. Invalid environment or server.');
}
function createRequestHandlerFactory(baseUrlProvider, authProvider, httpClient, addons, retryConfig, loggingOptions) {
    const requestBuilderFactory = createRequestBuilderFactory(createHttpClientAdapter(httpClient), baseUrlProvider, ApiError, authProvider, retryConfig, undefined, new ApiLogger(loggingOptions));
    return tap(requestBuilderFactory, ...addons);
}
function tap(requestBuilderFactory, ...callback) {
    return (...args) => {
        const requestBuilder = requestBuilderFactory(...args);
        callback.forEach((c) => c(requestBuilder));
        return requestBuilder;
    };
}
function withErrorHandlers(rb) {
    rb.defaultToError(ApiError);
}
function withUserAgent(userAgent) {
    return (rb) => {
        rb.interceptRequest((request) => {
            var _a;
            const headers = (_a = request.headers) !== null && _a !== void 0 ? _a : {};
            setHeader(headers, 'user-agent', userAgent);
            return Object.assign(Object.assign({}, request), { headers });
        });
    };
}
function withAuthenticationByDefault(rb) {
    rb.authenticate([]);
}
//# sourceMappingURL=client.js.map