/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { confirmOrderRequestSchema, } from '../models/confirmOrderRequest';
import { orderSchema } from '../models/order';
import { orderAuthorizeRequestSchema, } from '../models/orderAuthorizeRequest';
import { orderAuthorizeResponseSchema, } from '../models/orderAuthorizeResponse';
import { orderCaptureRequestSchema, } from '../models/orderCaptureRequest';
import { orderRequestSchema } from '../models/orderRequest';
import { orderTrackerRequestSchema, } from '../models/orderTrackerRequest';
import { patchSchema } from '../models/patch';
import { array, optional, string } from '../schema';
import { BaseController } from './baseController';
import { CustomError } from '../errors/customError';
export class OrdersController extends BaseController {
    /**
     * Updates an order with a `CREATED` or `APPROVED` status. You cannot update an order with the
     * `COMPLETED` status.<br/><br/>To make an update, you must provide a `reference_id`. If you omit this
     * value with an order that contains only one purchase unit, PayPal sets the value to `default` which
     * enables you to use the path: <code>\"/purchase_units/@reference_id=='default'/{attribute-or-
     * object}\"</code>. Merchants and partners can add Level 2 and 3 data to payments to reduce risk and
     * payment processing costs. For more information about processing payments, see <a href="https:
     * //developer.paypal.com/docs/checkout/advanced/processing/">checkout</a> or <a href="https:
     * //developer.paypal.com/docs/multiparty/checkout/advanced/processing/">multiparty checkout</a>.
     * <blockquote><strong>Note:</strong> For error handling and troubleshooting, see <a href="https:
     * //developer.paypal.com/api/rest/reference/orders/v2/errors/#patch-order">Orders v2 errors</a>.
     * </blockquote>Patchable attributes or objects:
     * <br/><br/><table><thead><th>Attribute</th><th>Op</th><th>Notes</th></thead><tbody><tr><td><code>inte
     * nt</code></td><td>replace</td><td></td></tr><tr><td><code>payer</code></td><td>replace,
     * add</td><td>Using replace op for <code>payer</code> will replace the whole <code>payer</code> object
     * with the value sent in request.</td></tr><tr><td><code>purchase_units</code></td><td>replace,
     * add</td><td></td></tr><tr><td><code>purchase_units[].custom_id</code></td><td>replace, add,
     * remove</td><td></td></tr><tr><td><code>purchase_units[].description</code></td><td>replace, add,
     * remove</td><td></td></tr><tr><td><code>purchase_units[].payee.
     * email</code></td><td>replace</td><td></td></tr><tr><td><code>purchase_units[].shipping.
     * name</code></td><td>replace, add</td><td></td></tr><tr><td><code>purchase_units[].shipping.
     * email_address</code></td><td>replace, add</td><td></td></tr><tr><td><code>purchase_units[].shipping.
     * phone_number</code></td><td>replace, add</td><td></td></tr><tr><td><code>purchase_units[].shipping.
     * options</code></td><td>replace, add</td><td></td></tr><tr><td><code>purchase_units[].shipping.
     * address</code></td><td>replace, add</td><td></td></tr><tr><td><code>purchase_units[].shipping.
     * type</code></td><td>replace, add</td><td></td></tr><tr><td><code>purchase_units[].
     * soft_descriptor</code></td><td>replace, remove</td><td></td></tr><tr><td><code>purchase_units[].
     * amount</code></td><td>replace</td><td></td></tr><tr><td><code>purchase_units[].
     * items</code></td><td>replace, add, remove</td><td></td></tr><tr><td><code>purchase_units[].
     * invoice_id</code></td><td>replace, add, remove</td><td></td></tr><tr><td><code>purchase_units[].
     * payment_instruction</code></td><td>replace</td><td></td></tr><tr><td><code>purchase_units[].
     * payment_instruction.disbursement_mode</code></td><td>replace</td><td>By default,
     * <code>disbursement_mode</code> is <code>INSTANT</code>.</td></tr><tr><td><code>purchase_units[].
     * payment_instruction.payee_receivable_fx_rate_id</code></td><td>replace, add,
     * remove</td><td></td></tr><tr><td><code>purchase_units[].payment_instruction.
     * platform_fees</code></td><td>replace, add, remove</td><td></td></tr><tr><td><code>purchase_units[].
     * supplementary_data.airline</code></td><td>replace, add,
     * remove</td><td></td></tr><tr><td><code>purchase_units[].supplementary_data.
     * card</code></td><td>replace, add, remove</td><td></td></tr><tr><td><code>application_context.
     * client_configuration</code></td><td>replace, add</td><td></td></tr></tbody></table>
     *
     * @param id                    The ID of the order to update.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative testing in the
     *                                         sandbox. This header configures the sandbox into a negative testing state
     *                                         for transactions that include the merchant.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that identifies the
     *                                         merchant. For details, see PayPal-Auth-Assertion.
     * @param body
     * @return Response from the API call
     */
    async patchOrder({ id, paypalMockResponse, paypalAuthAssertion, body, }, requestOptions) {
        const req = this.createRequest('PATCH');
        const mapped = req.prepareArgs({
            id: [id, string()],
            paypalMockResponse: [paypalMockResponse, optional(string())],
            paypalAuthAssertion: [paypalAuthAssertion, optional(string())],
            body: [body, optional(array(patchSchema))],
        });
        req.header('Content-Type', 'application/json');
        req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
        req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
        req.json(mapped.body);
        req.appendTemplatePath `/v2/checkout/orders/${mapped.id}`;
        req.throwOn(400, CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
        req.throwOn(401, CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
        req.throwOn(404, CustomError, 'The specified resource does not exist.');
        req.throwOn(422, CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
        req.defaultToError(CustomError, 'The error response.');
        req.authenticate([{ oauth2: true }]);
        return req.call(requestOptions);
    }
    /**
     * Authorizes payment for an order. To successfully authorize payment for an order, the buyer must
     * first approve the order or a valid payment_source must be provided in the request. A buyer can
     * approve the order upon being redirected to the rel:approve URL that was returned in the HATEOAS
     * links in the create order response. Note: For error handling and troubleshooting, see Orders v2
     * errors.
     *
     * @param id                        The ID of the order for which to authorize.
     * @param paypalMockResponse        PayPal's REST API uses a request header to
     *                                                                  invoke negative testing in the sandbox. This
     *                                                                  header configures the sandbox into a negative
     *                                                                  testing state for transactions that include the
     *                                                                  merchant.
     * @param paypalRequestId           The server stores keys for 6 hours. The API
     *                                                                  callers can request the times to up to 72 hours
     *                                                                  by speaking to their Account Manager. It is
     *                                                                  mandatory for all single-step create order calls
     *                                                                  (E.g. Create Order Request with payment source
     *                                                                  information like Card, PayPal.vault_id, PayPal.
     *                                                                  billing_agreement_id, etc).
     * @param prefer                    The preferred server response upon successful
     *                                                                  completion of the request. Value is:
     *                                                                  return=minimal. The server returns a minimal
     *                                                                  response to optimize communication between the
     *                                                                  API caller and the server. A minimal response
     *                                                                  includes the id, status and HATEOAS links.
     *                                                                  return=representation. The server returns a
     *                                                                  complete resource representation, including the
     *                                                                  current state of the resource.
     * @param paypalClientMetadataId
     * @param paypalAuthAssertion       An API-caller-provided JSON Web Token (JWT)
     *                                                                  assertion that identifies the merchant. For
     *                                                                  details, see PayPal-Auth-Assertion.
     * @param body
     * @return Response from the API call
     */
    async authorizeOrder({ id, paypalMockResponse, paypalRequestId, prefer, paypalClientMetadataId, paypalAuthAssertion, body, }, requestOptions) {
        const req = this.createRequest('POST');
        const mapped = req.prepareArgs({
            id: [id, string()],
            paypalMockResponse: [paypalMockResponse, optional(string())],
            paypalRequestId: [paypalRequestId, optional(string())],
            prefer: [prefer, optional(string())],
            paypalClientMetadataId: [paypalClientMetadataId, optional(string())],
            paypalAuthAssertion: [paypalAuthAssertion, optional(string())],
            body: [body, optional(orderAuthorizeRequestSchema)],
        });
        req.header('Content-Type', 'application/json');
        req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
        req.header('PayPal-Request-Id', mapped.paypalRequestId);
        req.header('Prefer', mapped.prefer);
        req.header('PayPal-Client-Metadata-Id', mapped.paypalClientMetadataId);
        req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
        req.json(mapped.body);
        req.appendTemplatePath `/v2/checkout/orders/${mapped.id}/authorize`;
        req.throwOn(400, CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
        req.throwOn(401, CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
        req.throwOn(403, CustomError, 'The authorized payment failed due to insufficient permissions.');
        req.throwOn(404, CustomError, 'The specified resource does not exist.');
        req.throwOn(422, CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
        req.throwOn(500, CustomError, 'An internal server error has occurred.');
        req.defaultToError(CustomError, 'The error response.');
        req.authenticate([{ oauth2: true }]);
        return req.callAsJson(orderAuthorizeResponseSchema, requestOptions);
    }
    /**
     * Updates or cancels the tracking information for a PayPal order, by ID. Updatable attributes or
     * objects: Attribute Op Notes items replace Using replace op for items will replace the entire items
     * object with the value sent in request. notify_payer replace, add status replace Only patching status
     * to CANCELLED is currently supported.
     *
     * @param id                    The ID of the order that the tracking information is associated with.
     * @param trackerId             The order tracking ID.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that identifies the
     *                                         merchant. For details, see PayPal-Auth-Assertion.
     * @param body
     * @return Response from the API call
     */
    async updateOrderTracking({ id, trackerId, paypalAuthAssertion, body, }, requestOptions) {
        const req = this.createRequest('PATCH');
        const mapped = req.prepareArgs({
            id: [id, string()],
            trackerId: [trackerId, string()],
            paypalAuthAssertion: [paypalAuthAssertion, optional(string())],
            body: [body, optional(array(patchSchema))],
        });
        req.header('Content-Type', 'application/json');
        req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
        req.json(mapped.body);
        req.appendTemplatePath `/v2/checkout/orders/${mapped.id}/trackers/${mapped.trackerId}`;
        req.throwOn(400, CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
        req.throwOn(403, CustomError, 'Authorization failed due to insufficient permissions.');
        req.throwOn(404, CustomError, 'The specified resource does not exist.');
        req.throwOn(422, CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
        req.throwOn(500, CustomError, 'An internal server error has occurred.');
        req.defaultToError(CustomError, 'The error response.');
        req.authenticate([{ oauth2: true }]);
        return req.call(requestOptions);
    }
    /**
     * Adds tracking information for an Order.
     *
     * @param id                    The ID of the order that the tracking information is
     *                                                            associated with.
     * @param body
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion
     *                                                            that identifies the merchant. For details, see PayPal-
     *                                                            Auth-Assertion.
     * @return Response from the API call
     */
    async createOrderTracking({ id, body, paypalAuthAssertion, }, requestOptions) {
        const req = this.createRequest('POST');
        const mapped = req.prepareArgs({
            id: [id, string()],
            body: [body, orderTrackerRequestSchema],
            paypalAuthAssertion: [paypalAuthAssertion, optional(string())],
        });
        req.header('Content-Type', 'application/json');
        req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
        req.json(mapped.body);
        req.appendTemplatePath `/v2/checkout/orders/${mapped.id}/track`;
        req.throwOn(400, CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
        req.throwOn(403, CustomError, 'Authorization failed due to insufficient permissions.');
        req.throwOn(404, CustomError, 'The specified resource does not exist.');
        req.throwOn(422, CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
        req.throwOn(500, CustomError, 'An internal server error has occurred.');
        req.defaultToError(CustomError, 'The error response.');
        req.authenticate([{ oauth2: true }]);
        return req.callAsJson(orderSchema, requestOptions);
    }
    /**
     * Creates an order. Merchants and partners can add Level 2 and 3 data to payments to reduce risk and
     * payment processing costs. For more information about processing payments, see checkout or multiparty
     * checkout. Note: For error handling and troubleshooting, see Orders v2 errors.
     *
     * @param body
     * @param paypalMockResponse            PayPal's REST API uses a request header to invoke
     *                                                             negative testing in the sandbox. This header
     *                                                             configures the sandbox into a negative testing state
     *                                                             for transactions that include the merchant.
     * @param paypalRequestId               The server stores keys for 6 hours. The API callers
     *                                                             can request the times to up to 72 hours by speaking to
     *                                                             their Account Manager. It is mandatory for all single-
     *                                                             step create order calls (E.g. Create Order Request
     *                                                             with payment source information like Card, PayPal.
     *                                                             vault_id, PayPal.billing_agreement_id, etc).
     * @param paypalPartnerAttributionId
     * @param paypalClientMetadataId
     * @param prefer                        The preferred server response upon successful
     *                                                             completion of the request. Value is: return=minimal.
     *                                                             The server returns a minimal response to optimize
     *                                                             communication between the API caller and the server. A
     *                                                             minimal response includes the id, status and HATEOAS
     *                                                             links. return=representation. The server returns a
     *                                                             complete resource representation, including the
     *                                                             current state of the resource.
     * @param paypalAuthAssertion           An API-caller-provided JSON Web Token (JWT) assertion
     *                                                             that identifies the merchant. For details, see PayPal-
     *                                                             Auth-Assertion.
     * @return Response from the API call
     */
    async createOrder({ body, paypalMockResponse, paypalRequestId, paypalPartnerAttributionId, paypalClientMetadataId, prefer, paypalAuthAssertion, }, requestOptions) {
        const req = this.createRequest('POST', '/v2/checkout/orders');
        const mapped = req.prepareArgs({
            body: [body, orderRequestSchema],
            paypalMockResponse: [paypalMockResponse, optional(string())],
            paypalRequestId: [paypalRequestId, optional(string())],
            paypalPartnerAttributionId: [
                paypalPartnerAttributionId,
                optional(string()),
            ],
            paypalClientMetadataId: [paypalClientMetadataId, optional(string())],
            prefer: [prefer, optional(string())],
            paypalAuthAssertion: [paypalAuthAssertion, optional(string())],
        });
        req.header('Content-Type', 'application/json');
        req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
        req.header('PayPal-Request-Id', mapped.paypalRequestId);
        req.header('PayPal-Partner-Attribution-Id', mapped.paypalPartnerAttributionId);
        req.header('PayPal-Client-Metadata-Id', mapped.paypalClientMetadataId);
        req.header('Prefer', mapped.prefer);
        req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
        req.json(mapped.body);
        req.throwOn(400, CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
        req.throwOn(401, CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
        req.throwOn(422, CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
        req.defaultToError(CustomError, 'The error response.');
        req.authenticate([{ oauth2: true }]);
        return req.callAsJson(orderSchema, requestOptions);
    }
    /**
     * Captures payment for an order. To successfully capture payment for an order, the buyer must first
     * approve the order or a valid payment_source must be provided in the request. A buyer can approve the
     * order upon being redirected to the rel:approve URL that was returned in the HATEOAS links in the
     * create order response. Note: For error handling and troubleshooting, see Orders v2 errors.
     *
     * @param id                        The ID of the order for which to capture a payment.
     * @param paypalMockResponse        PayPal's REST API uses a request header to invoke
     *                                                                negative testing in the sandbox. This header
     *                                                                configures the sandbox into a negative testing
     *                                                                state for transactions that include the merchant.
     * @param paypalRequestId           The server stores keys for 6 hours. The API
     *                                                                callers can request the times to up to 72 hours by
     *                                                                speaking to their Account Manager. It is mandatory
     *                                                                for all single-step create order calls (E.g. Create
     *                                                                Order Request with payment source information like
     *                                                                Card, PayPal.vault_id, PayPal.billing_agreement_id,
     *                                                                etc).
     * @param prefer                    The preferred server response upon successful
     *                                                                completion of the request. Value is: return=minimal.
     *                                                                The server returns a minimal response to optimize
     *                                                                communication between the API caller and the server.
     *                                                                A minimal response includes the id, status and
     *                                                                HATEOAS links. return=representation. The server
     *                                                                returns a complete resource representation,
     *                                                                including the current state of the resource.
     * @param paypalClientMetadataId
     * @param paypalAuthAssertion       An API-caller-provided JSON Web Token (JWT)
     *                                                                assertion that identifies the merchant. For details,
     *                                                                see PayPal-Auth-Assertion.
     * @param body
     * @return Response from the API call
     */
    async captureOrder({ id, paypalMockResponse, paypalRequestId, prefer, paypalClientMetadataId, paypalAuthAssertion, body, }, requestOptions) {
        const req = this.createRequest('POST');
        const mapped = req.prepareArgs({
            id: [id, string()],
            paypalMockResponse: [paypalMockResponse, optional(string())],
            paypalRequestId: [paypalRequestId, optional(string())],
            prefer: [prefer, optional(string())],
            paypalClientMetadataId: [paypalClientMetadataId, optional(string())],
            paypalAuthAssertion: [paypalAuthAssertion, optional(string())],
            body: [body, optional(orderCaptureRequestSchema)],
        });
        req.header('Content-Type', 'application/json');
        req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
        req.header('PayPal-Request-Id', mapped.paypalRequestId);
        req.header('Prefer', mapped.prefer);
        req.header('PayPal-Client-Metadata-Id', mapped.paypalClientMetadataId);
        req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
        req.json(mapped.body);
        req.appendTemplatePath `/v2/checkout/orders/${mapped.id}/capture`;
        req.throwOn(400, CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
        req.throwOn(401, CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
        req.throwOn(403, CustomError, 'The authorized payment failed due to insufficient permissions.');
        req.throwOn(404, CustomError, 'The specified resource does not exist.');
        req.throwOn(422, CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
        req.throwOn(500, CustomError, 'An internal server error has occurred.');
        req.defaultToError(CustomError, 'The error response.');
        req.authenticate([{ oauth2: true }]);
        return req.callAsJson(orderSchema, requestOptions);
    }
    /**
     * Shows details for an order, by ID. Note: For error handling and troubleshooting, see Orders v2
     * errors.
     *
     * @param id                    The ID of the order for which to show details.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative testing in the
     *                                        sandbox. This header configures the sandbox into a negative testing state
     *                                        for transactions that include the merchant.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that identifies the
     *                                        merchant. For details, see PayPal-Auth-Assertion.
     * @param fields                A comma-separated list of fields that should be returned for the order.
     *                                        Valid filter field is `payment_source`.
     * @return Response from the API call
     */
    async getOrder({ id, paypalMockResponse, paypalAuthAssertion, fields, }, requestOptions) {
        const req = this.createRequest('GET');
        const mapped = req.prepareArgs({
            id: [id, string()],
            paypalMockResponse: [paypalMockResponse, optional(string())],
            paypalAuthAssertion: [paypalAuthAssertion, optional(string())],
            fields: [fields, optional(string())],
        });
        req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
        req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
        req.query('fields', mapped.fields);
        req.appendTemplatePath `/v2/checkout/orders/${mapped.id}`;
        req.throwOn(401, CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
        req.throwOn(404, CustomError, 'The specified resource does not exist.');
        req.defaultToError(CustomError, 'The error response.');
        req.authenticate([{ oauth2: true }]);
        return req.callAsJson(orderSchema, requestOptions);
    }
    /**
     * Payer confirms their intent to pay for the the Order with the given payment source.
     *
     * @param id                        The ID of the order for which the payer confirms
     *                                                                their intent to pay.
     * @param paypalClientMetadataId
     * @param paypalAuthAssertion       An API-caller-provided JSON Web Token (JWT)
     *                                                                assertion that identifies the merchant. For details,
     *                                                                see PayPal-Auth-Assertion.
     * @param prefer                    The preferred server response upon successful
     *                                                                completion of the request. Value is: return=minimal.
     *                                                                The server returns a minimal response to optimize
     *                                                                communication between the API caller and the server.
     *                                                                A minimal response includes the id, status and
     *                                                                HATEOAS links. return=representation. The server
     *                                                                returns a complete resource representation,
     *                                                                including the current state of the resource.
     * @param body
     * @return Response from the API call
     */
    async confirmOrder({ id, paypalClientMetadataId, paypalAuthAssertion, prefer, body, }, requestOptions) {
        const req = this.createRequest('POST');
        const mapped = req.prepareArgs({
            id: [id, string()],
            paypalClientMetadataId: [paypalClientMetadataId, optional(string())],
            paypalAuthAssertion: [paypalAuthAssertion, optional(string())],
            prefer: [prefer, optional(string())],
            body: [body, optional(confirmOrderRequestSchema)],
        });
        req.header('Content-Type', 'application/json');
        req.header('PayPal-Client-Metadata-Id', mapped.paypalClientMetadataId);
        req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
        req.header('Prefer', mapped.prefer);
        req.json(mapped.body);
        req.appendTemplatePath `/v2/checkout/orders/${mapped.id}/confirm-payment-source`;
        req.throwOn(400, CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
        req.throwOn(403, CustomError, 'Authorization failed due to insufficient permissions.');
        req.throwOn(422, CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
        req.throwOn(500, CustomError, 'An internal server error has occurred.');
        req.defaultToError(CustomError, 'The error response.');
        req.authenticate([{ oauth2: true }]);
        return req.callAsJson(orderSchema, requestOptions);
    }
}
//# sourceMappingURL=ordersController.js.map