/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { ApiResponse, RequestOptions } from '../core';
import { CapturedPayment } from '../models/capturedPayment';
import { CaptureRequest } from '../models/captureRequest';
import { PaymentAuthorization } from '../models/paymentAuthorization';
import { ReauthorizeRequest } from '../models/reauthorizeRequest';
import { Refund } from '../models/refund';
import { RefundRequest } from '../models/refundRequest';
import { BaseController } from './baseController';
export declare class PaymentsController extends BaseController {
    /**
     * Captures an authorized payment, by ID.
     *
     * @param authorizationId       The PayPal-generated ID for the authorized payment to
     *                                                       capture.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative
     *                                                       testing in the sandbox. This header configures the sandbox
     *                                                       into a negative testing state for transactions that include
     *                                                       the merchant.
     * @param paypalRequestId       The server stores keys for 45 days.
     * @param prefer                The preferred server response upon successful completion of
     *                                                       the request. Value is: return=minimal. The server returns a
     *                                                       minimal response to optimize communication between the API
     *                                                       caller and the server. A minimal response includes the id,
     *                                                       status and HATEOAS links. return=representation. The server
     *                                                       returns a complete resource representation, including the
     *                                                       current state of the resource.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that
     *                                                       identifies the merchant. For details, see [PayPal-Auth-
     *                                                       Assertion](/docs/api/reference/api-requests/#paypal-auth-
     *                                                       assertion). Note:For three party transactions in which a
     *                                                       partner is managing the API calls on behalf of a merchant,
     *                                                       the partner must identify the merchant using either a PayPal-
     *                                                       Auth-Assertion header or an access token with target_subject.
     * @param body
     * @return Response from the API call
     */
    captureAuthorizedPayment({ authorizationId, paypalMockResponse, paypalRequestId, prefer, paypalAuthAssertion, body, }: {
        authorizationId: string;
        paypalMockResponse?: string;
        paypalRequestId?: string;
        prefer?: string;
        paypalAuthAssertion?: string;
        body?: CaptureRequest;
    }, requestOptions?: RequestOptions): Promise<ApiResponse<CapturedPayment>>;
    /**
     * Shows details for a captured payment, by ID.
     *
     * @param captureId            The PayPal-generated ID for the captured payment for which to show details.
     * @param paypalMockResponse   PayPal's REST API uses a request header to invoke negative testing in the
     *                                       sandbox. This header configures the sandbox into a negative testing state
     *                                       for transactions that include the merchant.
     * @return Response from the API call
     */
    getCapturedPayment({ captureId, paypalMockResponse, }: {
        captureId: string;
        paypalMockResponse?: string;
    }, requestOptions?: RequestOptions): Promise<ApiResponse<CapturedPayment>>;
    /**
     * Reauthorizes an authorized PayPal account payment, by ID. To ensure that funds are still available,
     * reauthorize a payment after its initial three-day honor period expires. Within the 29-day
     * authorization period, you can issue multiple re-authorizations after the honor period expires. If 30
     * days have transpired since the date of the original authorization, you must create an authorized
     * payment instead of reauthorizing the original authorized payment. A reauthorized payment itself has
     * a new honor period of three days. You can reauthorize an authorized payment from 4 to 29 days after
     * the 3-day honor period. The allowed amount depends on context and geography, for example in US it is
     * up to 115% of the original authorized amount, not to exceed an increase of $75 USD. Supports only
     * the `amount` request parameter. Note: This request is currently not supported for Partner use cases.
     *
     * @param authorizationId       The PayPal-generated ID for the authorized payment to
     *                                                           reauthorize.
     * @param paypalRequestId       The server stores keys for 45 days.
     * @param prefer                The preferred server response upon successful
     *                                                           completion of the request. Value is: return=minimal. The
     *                                                           server returns a minimal response to optimize
     *                                                           communication between the API caller and the server. A
     *                                                           minimal response includes the id, status and HATEOAS
     *                                                           links. return=representation. The server returns a
     *                                                           complete resource representation, including the current
     *                                                           state of the resource.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion
     *                                                           that identifies the merchant. For details, see [PayPal-
     *                                                           Auth-Assertion](/docs/api/reference/api-requests/#paypal-
     *                                                           auth-assertion). Note:For three party transactions in
     *                                                           which a partner is managing the API calls on behalf of a
     *                                                           merchant, the partner must identify the merchant using
     *                                                           either a PayPal-Auth-Assertion header or an access token
     *                                                           with target_subject.
     * @param body
     * @return Response from the API call
     */
    reauthorizePayment({ authorizationId, paypalRequestId, prefer, paypalAuthAssertion, body, }: {
        authorizationId: string;
        paypalRequestId?: string;
        prefer?: string;
        paypalAuthAssertion?: string;
        body?: ReauthorizeRequest;
    }, requestOptions?: RequestOptions): Promise<ApiResponse<PaymentAuthorization>>;
    /**
     * Voids, or cancels, an authorized payment, by ID. You cannot void an authorized payment that has been
     * fully captured.
     *
     * @param authorizationId       The PayPal-generated ID for the authorized payment to void.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative testing in the
     *                                        sandbox. This header configures the sandbox into a negative testing state
     *                                        for transactions that include the merchant.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that identifies the
     *                                        merchant. For details, see [PayPal-Auth-Assertion](/docs/api/reference/api-
     *                                        requests/#paypal-auth-assertion). Note:For three party transactions in
     *                                        which a partner is managing the API calls on behalf of a merchant, the
     *                                        partner must identify the merchant using either a PayPal-Auth-Assertion
     *                                        header or an access token with target_subject.
     * @param paypalRequestId       The server stores keys for 45 days.
     * @param prefer                The preferred server response upon successful completion of the request.
     *                                        Value is: return=minimal. The server returns a minimal response to optimize
     *                                        communication between the API caller and the server. A minimal response
     *                                        includes the id, status and HATEOAS links. return=representation. The
     *                                        server returns a complete resource representation, including the current
     *                                        state of the resource.
     * @return Response from the API call
     */
    voidPayment({ authorizationId, paypalMockResponse, paypalAuthAssertion, paypalRequestId, prefer, }: {
        authorizationId: string;
        paypalMockResponse?: string;
        paypalAuthAssertion?: string;
        paypalRequestId?: string;
        prefer?: string;
    }, requestOptions?: RequestOptions): Promise<ApiResponse<PaymentAuthorization | null>>;
    /**
     * Refunds a captured payment, by ID. For a full refund, include an empty payload in the JSON request
     * body. For a partial refund, include an amount object in the JSON request body.
     *
     * @param captureId             The PayPal-generated ID for the captured payment to refund.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative
     *                                                      testing in the sandbox. This header configures the sandbox
     *                                                      into a negative testing state for transactions that include
     *                                                      the merchant.
     * @param paypalRequestId       The server stores keys for 45 days.
     * @param prefer                The preferred server response upon successful completion of
     *                                                      the request. Value is: return=minimal. The server returns a
     *                                                      minimal response to optimize communication between the API
     *                                                      caller and the server. A minimal response includes the id,
     *                                                      status and HATEOAS links. return=representation. The server
     *                                                      returns a complete resource representation, including the
     *                                                      current state of the resource.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that
     *                                                      identifies the merchant. For details, see [PayPal-Auth-
     *                                                      Assertion](/docs/api/reference/api-requests/#paypal-auth-
     *                                                      assertion). Note:For three party transactions in which a
     *                                                      partner is managing the API calls on behalf of a merchant,
     *                                                      the partner must identify the merchant using either a PayPal-
     *                                                      Auth-Assertion header or an access token with target_subject.
     * @param body
     * @return Response from the API call
     */
    refundCapturedPayment({ captureId, paypalMockResponse, paypalRequestId, prefer, paypalAuthAssertion, body, }: {
        captureId: string;
        paypalMockResponse?: string;
        paypalRequestId?: string;
        prefer?: string;
        paypalAuthAssertion?: string;
        body?: RefundRequest;
    }, requestOptions?: RequestOptions): Promise<ApiResponse<Refund>>;
    /**
     * Shows details for an authorized payment, by ID.
     *
     * @param authorizationId       The ID of the authorized payment for which to show details.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative testing in the
     *                                        sandbox. This header configures the sandbox into a negative testing state
     *                                        for transactions that include the merchant.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that identifies the
     *                                        merchant. For details, see [PayPal-Auth-Assertion](/docs/api/reference/api-
     *                                        requests/#paypal-auth-assertion). Note:For three party transactions in
     *                                        which a partner is managing the API calls on behalf of a merchant, the
     *                                        partner must identify the merchant using either a PayPal-Auth-Assertion
     *                                        header or an access token with target_subject.
     * @return Response from the API call
     */
    getAuthorizedPayment({ authorizationId, paypalMockResponse, paypalAuthAssertion, }: {
        authorizationId: string;
        paypalMockResponse?: string;
        paypalAuthAssertion?: string;
    }, requestOptions?: RequestOptions): Promise<ApiResponse<PaymentAuthorization>>;
    /**
     * Shows details for a refund, by ID.
     *
     * @param refundId              The PayPal-generated ID for the refund for which to show details.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative testing in the
     *                                        sandbox. This header configures the sandbox into a negative testing state
     *                                        for transactions that include the merchant.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that identifies the
     *                                        merchant. For details, see [PayPal-Auth-Assertion](/docs/api/reference/api-
     *                                        requests/#paypal-auth-assertion). Note:For three party transactions in
     *                                        which a partner is managing the API calls on behalf of a merchant, the
     *                                        partner must identify the merchant using either a PayPal-Auth-Assertion
     *                                        header or an access token with target_subject.
     * @return Response from the API call
     */
    getRefund({ refundId, paypalMockResponse, paypalAuthAssertion, }: {
        refundId: string;
        paypalMockResponse?: string;
        paypalAuthAssertion?: string;
    }, requestOptions?: RequestOptions): Promise<ApiResponse<Refund>>;
}
//# sourceMappingURL=paymentsController.d.ts.map