/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { ApiResponse, RequestOptions } from '../core';
import { CustomerVaultPaymentTokensResponse } from '../models/customerVaultPaymentTokensResponse';
import { PaymentTokenRequest } from '../models/paymentTokenRequest';
import { PaymentTokenResponse } from '../models/paymentTokenResponse';
import { SetupTokenRequest } from '../models/setupTokenRequest';
import { SetupTokenResponse } from '../models/setupTokenResponse';
import { BaseController } from './baseController';
export declare class VaultController extends BaseController {
    /**
     * Delete the payment token associated with the payment token id.
     *
     * @param id ID of the payment token.
     * @return Response from the API call
     */
    deletePaymentToken(id: string, requestOptions?: RequestOptions): Promise<ApiResponse<void>>;
    /**
     * Creates a Setup Token from the given payment source and adds it to the Vault of the associated
     * customer.
     *
     * @param body              Setup Token creation with a instrument type optional
     *                                                      financial instrument details and customer_id.
     * @param paypalRequestId   The server stores keys for 3 hours.
     * @return Response from the API call
     */
    createSetupToken({ body, paypalRequestId, }: {
        body: SetupTokenRequest;
        paypalRequestId?: string;
    }, requestOptions?: RequestOptions): Promise<ApiResponse<SetupTokenResponse>>;
    /**
     * Returns a readable representation of temporarily vaulted payment source associated with the setup
     * token id.
     *
     * @param id ID of the setup token.
     * @return Response from the API call
     */
    getSetupToken(id: string, requestOptions?: RequestOptions): Promise<ApiResponse<SetupTokenResponse>>;
    /**
     * Creates a Payment Token from the given payment source and adds it to the Vault of the associated
     * customer.
     *
     * @param body              Payment Token creation with a financial instrument and an
     *                                                        optional customer_id.
     * @param paypalRequestId   The server stores keys for 3 hours.
     * @return Response from the API call
     */
    createPaymentToken({ body, paypalRequestId, }: {
        body: PaymentTokenRequest;
        paypalRequestId?: string;
    }, requestOptions?: RequestOptions): Promise<ApiResponse<PaymentTokenResponse>>;
    /**
     * Returns all payment tokens for a customer.
     *
     * @param customerId     A unique identifier representing a specific customer in merchant's/partner's
     *                                  system or records.
     * @param pageSize       A non-negative, non-zero integer indicating the maximum number of results to
     *                                  return at one time.
     * @param page           A non-negative, non-zero integer representing the page of the results.
     * @param totalRequired  A boolean indicating total number of items (total_items) and pages (total_pages)
     *                                  are expected to be returned in the response.
     * @return Response from the API call
     */
    listCustomerPaymentTokens({ customerId, pageSize, page, totalRequired, }: {
        customerId: string;
        pageSize?: number;
        page?: number;
        totalRequired?: boolean;
    }, requestOptions?: RequestOptions): Promise<ApiResponse<CustomerVaultPaymentTokensResponse>>;
    /**
     * Returns a readable representation of vaulted payment source associated with the payment token id.
     *
     * @param id ID of the payment token.
     * @return Response from the API call
     */
    getPaymentToken(id: string, requestOptions?: RequestOptions): Promise<ApiResponse<PaymentTokenResponse>>;
}
//# sourceMappingURL=vaultController.d.ts.map