/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { Schema } from '../schema';
import { ApplePayAttributes } from './applePayAttributes';
import { ApplePayDecryptedTokenData } from './applePayDecryptedTokenData';
import { ApplePayExperienceContext } from './applePayExperienceContext';
import { CardStoredCredential } from './cardStoredCredential';
import { PhoneNumber } from './phoneNumber';
/** Information needed to pay using ApplePay. */
export interface ApplePayRequest {
    /** ApplePay transaction identifier, this will be the unique identifier for this transaction provided by Apple. The pattern is defined by an external party and supports Unicode. */
    id?: string;
    /** The full name representation like Mr J Smith. */
    name?: string;
    /** The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters are allowed after the @ sign. However, the generally accepted maximum length for an email address is 254 characters. The pattern verifies that an unquoted @ sign exists. */
    emailAddress?: string;
    /** The phone number in its canonical international [E.164 numbering plan format](https://www.itu.int/rec/T-REC-E.164/en). */
    phoneNumber?: PhoneNumber;
    /** Information about the Payment data obtained by decrypting Apple Pay token. */
    decryptedToken?: ApplePayDecryptedTokenData;
    /** Provides additional details to process a payment using a `card` that has been stored or is intended to be stored (also referred to as stored_credential or card-on-file). Parameter compatibility: `payment_type=ONE_TIME` is compatible only with `payment_initiator=CUSTOMER`. `usage=FIRST` is compatible only with `payment_initiator=CUSTOMER`. `previous_transaction_reference` or `previous_network_transaction_reference` is compatible only with `payment_initiator=MERCHANT`. Only one of the parameters - `previous_transaction_reference` and `previous_network_transaction_reference` - can be present in the request. */
    storedCredential?: CardStoredCredential;
    /** The PayPal-generated ID for the vaulted payment source. This ID should be stored on the merchant's server so the saved payment source can be used for future transactions. */
    vaultId?: string;
    /** Additional attributes associated with apple pay. */
    attributes?: ApplePayAttributes;
    /** Customizes the payer experience during the approval process for the payment. */
    experienceContext?: ApplePayExperienceContext;
}
export declare const applePayRequestSchema: Schema<ApplePayRequest>;
//# sourceMappingURL=applePayRequest.d.ts.map