/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { Schema } from '../schema';
import { CaptureStatus } from './captureStatus';
import { CaptureStatusDetails } from './captureStatusDetails';
import { DisbursementMode } from './disbursementMode';
import { LinkDescription } from './linkDescription';
import { Money } from './money';
import { NetworkTransactionReference } from './networkTransactionReference';
import { PayeeBase } from './payeeBase';
import { PaymentsProcessorResponse } from './paymentsProcessorResponse';
import { PaymentSupplementaryData } from './paymentSupplementaryData';
import { SellerProtection } from './sellerProtection';
import { SellerReceivableBreakdown } from './sellerReceivableBreakdown';
/** A captured payment. */
export interface CapturedPayment {
    /** The status of the captured payment. */
    status?: CaptureStatus;
    /** The details of the captured payment status. */
    statusDetails?: CaptureStatusDetails;
    /** The PayPal-generated ID for the captured payment. */
    id?: string;
    /** The currency and amount for a financial transaction, such as a balance or payment due. */
    amount?: Money;
    /** The API caller-provided external invoice number for this order. Appears in both the payer's transaction history and the emails that the payer receives. */
    invoiceId?: string;
    /** The API caller-provided external ID. Used to reconcile API caller-initiated transactions with PayPal transactions. Appears in transaction and settlement reports. */
    customId?: string;
    /** Reference values used by the card network to identify a transaction. */
    networkTransactionReference?: NetworkTransactionReference;
    /** The level of protection offered as defined by [PayPal Seller Protection for Merchants](https://www.paypal.com/us/webapps/mpp/security/seller-protection). */
    sellerProtection?: SellerProtection;
    /** Indicates whether you can make additional captures against the authorized payment. Set to `true` if you do not intend to capture additional payments against the authorization. Set to `false` if you intend to capture additional payments against the authorization. */
    finalCapture?: boolean;
    /** The detailed breakdown of the capture activity. This is not available for transactions that are in pending state. */
    sellerReceivableBreakdown?: SellerReceivableBreakdown;
    /** The funds that are held on behalf of the merchant. */
    disbursementMode?: DisbursementMode;
    /** An array of related [HATEOAS links](/docs/api/reference/api-responses/#hateoas-links). */
    links?: LinkDescription[];
    /** The processor response information for payment requests, such as direct credit card transactions. */
    processorResponse?: PaymentsProcessorResponse;
    /** The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds are required while fractional seconds are optional. Note: The regular expression provides guidance but does not reject all invalid dates. */
    createTime?: string;
    /** The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds are required while fractional seconds are optional. Note: The regular expression provides guidance but does not reject all invalid dates. */
    updateTime?: string;
    /** The supplementary data. */
    supplementaryData?: PaymentSupplementaryData;
    /** The details for the merchant who receives the funds and fulfills the order. The merchant is also known as the payee. */
    payee?: PayeeBase;
}
export declare const capturedPaymentSchema: Schema<CapturedPayment>;
//# sourceMappingURL=capturedPayment.d.ts.map