/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { Schema } from '../schema';
import { StoredPaymentSource } from './storedPaymentSource';
/** Customizes the payer confirmation experience. */
export interface OrderConfirmApplicationContext {
    /** Label to present to your payer as part of the PayPal hosted web experience. */
    brandName?: string;
    /** The [language tag](https://tools.ietf.org/html/bcp47#section-2) for the language in which to localize the error-related strings, such as messages, issues, and suggested actions. The tag is made up of the [ISO 639-2 language code](https://www.loc.gov/standards/iso639-2/php/code_list.php), the optional [ISO-15924 script tag](https://www.unicode.org/iso15924/codelists.html), and the [ISO-3166 alpha-2 country code](/api/rest/reference/country-codes/) or [M49 region code](https://unstats.un.org/unsd/methodology/m49/). */
    locale?: string;
    /** The URL where the customer is redirected after the customer approves the payment. */
    returnUrl?: string;
    /** The URL where the customer is redirected after the customer cancels the payment. */
    cancelUrl?: string;
    /** Provides additional details to process a payment using a `payment_source` that has been stored or is intended to be stored (also referred to as stored_credential or card-on-file). Parameter compatibility: `payment_type=ONE_TIME` is compatible only with `payment_initiator=CUSTOMER`. `usage=FIRST` is compatible only with `payment_initiator=CUSTOMER`. `previous_transaction_reference` or `previous_network_transaction_reference` is compatible only with `payment_initiator=MERCHANT`. Only one of the parameters - `previous_transaction_reference` and `previous_network_transaction_reference` - can be present in the request. */
    storedPaymentSource?: StoredPaymentSource;
}
export declare const orderConfirmApplicationContextSchema: Schema<OrderConfirmApplicationContext>;
//# sourceMappingURL=orderConfirmApplicationContext.d.ts.map