/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { Schema } from '../schema';
import { Address } from './address';
import { CardBrand } from './cardBrand';
import { SetupTokenCardExperienceContext } from './setupTokenCardExperienceContext';
import { VaultCardVerificationMethod } from './vaultCardVerificationMethod';
/** A Resource representing a request to vault a Card. */
export interface SetupTokenRequestCard {
    /** The card holder's name as it appears on the card. */
    name?: string;
    /** The primary account number (PAN) for the payment card. */
    number?: string;
    /** The year and month, in ISO-8601 `YYYY-MM` date format. See [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.6). */
    expiry?: string;
    /** The three- or four-digit security code of the card. Also known as the CVV, CVC, CVN, CVE, or CID. This parameter cannot be present in the request when `payment_initiator=MERCHANT`. */
    securityCode?: string;
    /** The card network or brand. Applies to credit, debit, gift, and payment cards. */
    brand?: CardBrand;
    /** The portable international postal address. Maps to [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling form controls: the autocomplete attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute). */
    billingAddress?: Address;
    /** The verification method of the card. */
    verificationMethod?: VaultCardVerificationMethod;
    /** Customizes the Vault creation flow experience for your customers. */
    experienceContext?: SetupTokenCardExperienceContext;
}
export declare const setupTokenRequestCardSchema: Schema<SetupTokenRequestCard>;
//# sourceMappingURL=setupTokenRequestCard.d.ts.map