/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { Schema } from '../schema';
import { Money } from './money';
import { ShippingType } from './shippingType';
/** The options that the payee or merchant offers to the payer to ship or pick up their items. */
export interface ShippingOption {
    /** A unique ID that identifies a payer-selected shipping option. */
    id: string;
    /** A description that the payer sees, which helps them choose an appropriate shipping option. For example, `Free Shipping`, `USPS Priority Shipping`, `Expédition prioritaire USPS`, or `USPS yōuxiān fā huò`. Localize this description to the payer's locale. */
    label: string;
    /** A classification for the method of purchase fulfillment. */
    type?: ShippingType;
    /** The currency and amount for a financial transaction, such as a balance or payment due. */
    amount?: Money;
    /** If the API request sets `selected = true`, it represents the shipping option that the payee or merchant expects to be pre-selected for the payer when they first view the `shipping.options` in the PayPal Checkout experience. As part of the response if a `shipping.option` contains `selected=true`, it represents the shipping option that the payer selected during the course of checkout with PayPal. Only one `shipping.option` can be set to `selected=true`. */
    selected: boolean;
}
export declare const shippingOptionSchema: Schema<ShippingOption>;
//# sourceMappingURL=shippingOption.d.ts.map