/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, object, optional, Schema, string } from '../schema';
import { Address, addressSchema } from './address';
import {
  AuthenticationResponse,
  authenticationResponseSchema,
} from './authenticationResponse';
import { BinDetails, binDetailsSchema } from './binDetails';
import {
  CardAttributesResponse,
  cardAttributesResponseSchema,
} from './cardAttributesResponse';
import { CardBrand, cardBrandSchema } from './cardBrand';
import { CardFromRequest, cardFromRequestSchema } from './cardFromRequest';
import {
  CardStoredCredential,
  cardStoredCredentialSchema,
} from './cardStoredCredential';
import { CardType, cardTypeSchema } from './cardType';

/** The Card from Apple Pay Wallet used to fund the payment. */
export interface ApplePayCardResponse {
  /** The card holder's name as it appears on the card. */
  name?: string;
  /** The last digits of the payment card. */
  lastDigits?: string;
  /** The card network or brand. Applies to credit, debit, gift, and payment cards. */
  brand?: CardBrand;
  /** Array of brands or networks associated with the card. */
  availableNetworks?: CardBrand[];
  /** Type of card. i.e Credit, Debit and so on. */
  type?: CardType;
  /** Results of Authentication such as 3D Secure. */
  authenticationResult?: AuthenticationResponse;
  /** Additional attributes associated with the use of this card. */
  attributes?: CardAttributesResponse;
  /** Representation of card details as received in the request. */
  fromRequest?: CardFromRequest;
  /** The year and month, in ISO-8601 `YYYY-MM` date format. See [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.6). */
  expiry?: string;
  /** Bank Identification Number (BIN) details used to fund a payment. */
  binDetails?: BinDetails;
  /** Provides additional details to process a payment using a `card` that has been stored or is intended to be stored (also referred to as stored_credential or card-on-file). Parameter compatibility: `payment_type=ONE_TIME` is compatible only with `payment_initiator=CUSTOMER`. `usage=FIRST` is compatible only with `payment_initiator=CUSTOMER`. `previous_transaction_reference` or `previous_network_transaction_reference` is compatible only with `payment_initiator=MERCHANT`. Only one of the parameters - `previous_transaction_reference` and `previous_network_transaction_reference` - can be present in the request. */
  storedCredential?: CardStoredCredential;
  /** The portable international postal address. Maps to [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling form controls: the autocomplete attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute). */
  billingAddress?: Address;
  /** The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the country or region. Note: The country code for Great Britain is GB and not UK as used in the top-level domain names for that country. Use the `C2` country code for China worldwide for comparable uncontrolled price (CUP) method, bank card, and cross-border transactions. */
  countryCode?: string;
}

export const applePayCardResponseSchema: Schema<ApplePayCardResponse> = object({
  name: ['name', optional(string())],
  lastDigits: ['last_digits', optional(string())],
  brand: ['brand', optional(cardBrandSchema)],
  availableNetworks: ['available_networks', optional(array(cardBrandSchema))],
  type: ['type', optional(cardTypeSchema)],
  authenticationResult: [
    'authentication_result',
    optional(lazy(() => authenticationResponseSchema)),
  ],
  attributes: [
    'attributes',
    optional(lazy(() => cardAttributesResponseSchema)),
  ],
  fromRequest: ['from_request', optional(lazy(() => cardFromRequestSchema))],
  expiry: ['expiry', optional(string())],
  binDetails: ['bin_details', optional(lazy(() => binDetailsSchema))],
  storedCredential: [
    'stored_credential',
    optional(lazy(() => cardStoredCredentialSchema)),
  ],
  billingAddress: ['billing_address', optional(lazy(() => addressSchema))],
  countryCode: ['country_code', optional(string())],
});
