/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { boolean, lazy, object, optional, Schema, string } from '../schema';
import {
  CapturePaymentInstruction,
  capturePaymentInstructionSchema,
} from './capturePaymentInstruction';
import { Money, moneySchema } from './money';

export interface CaptureRequest {
  /** The API caller-provided external invoice number for this order. Appears in both the payer's transaction history and the emails that the payer receives. */
  invoiceId?: string;
  /** An informational note about this settlement. Appears in both the payer's transaction history and the emails that the payer receives. */
  noteToPayer?: string;
  /** The currency and amount for a financial transaction, such as a balance or payment due. */
  amount?: Money;
  /** Indicates whether you can make additional captures against the authorized payment. Set to `true` if you do not intend to capture additional payments against the authorization. Set to `false` if you intend to capture additional payments against the authorization. */
  finalCapture?: boolean;
  /** Any additional payment instructions to be consider during payment processing. This processing instruction is applicable for Capturing an order or Authorizing an Order. */
  paymentInstruction?: CapturePaymentInstruction;
  /** The payment descriptor on the payer's account statement. */
  softDescriptor?: string;
}

export const captureRequestSchema: Schema<CaptureRequest> = object({
  invoiceId: ['invoice_id', optional(string())],
  noteToPayer: ['note_to_payer', optional(string())],
  amount: ['amount', optional(lazy(() => moneySchema))],
  finalCapture: ['final_capture', optional(boolean())],
  paymentInstruction: [
    'payment_instruction',
    optional(lazy(() => capturePaymentInstructionSchema)),
  ],
  softDescriptor: ['soft_descriptor', optional(string())],
});
