/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, object, optional, Schema, string } from '../schema';
import {
  CardCustomerInformation,
  cardCustomerInformationSchema,
} from './cardCustomerInformation';
import { LinkDescription, linkDescriptionSchema } from './linkDescription';
import { VaultStatus, vaultStatusSchema } from './vaultStatus';

/** The details about a saved Card payment source. */
export interface CardVaultResponse {
  /** The PayPal-generated ID for the saved payment source. */
  id?: string;
  /** The vault status. */
  status?: VaultStatus;
  /** An array of request-related HATEOAS links. */
  links?: LinkDescription[];
  /** The details about a customer in PayPal's system of record. */
  customer?: CardCustomerInformation;
}

export const cardVaultResponseSchema: Schema<CardVaultResponse> = object({
  id: ['id', optional(string())],
  status: ['status', optional(vaultStatusSchema)],
  links: ['links', optional(array(lazy(() => linkDescriptionSchema)))],
  customer: ['customer', optional(lazy(() => cardCustomerInformationSchema))],
});
