/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, number, object, optional, Schema } from '../schema';
import { LinkDescription, linkDescriptionSchema } from './linkDescription';
import {
  PaymentTokenResponse,
  paymentTokenResponseSchema,
} from './paymentTokenResponse';
import {
  VaultResponseCustomer,
  vaultResponseCustomerSchema,
} from './vaultResponseCustomer';

/** Collection of payment tokens saved for a given customer. */
export interface CustomerVaultPaymentTokensResponse {
  /** Total number of items. */
  totalItems?: number;
  /** Total number of pages. */
  totalPages?: number;
  /** This object defines a customer in your system. Use it to manage customer profiles, save payment methods and contact details. */
  customer?: VaultResponseCustomer;
  paymentTokens?: PaymentTokenResponse[];
  /** An array of related [HATEOAS links](/api/rest/responses/#hateoas). */
  links?: LinkDescription[];
}

export const customerVaultPaymentTokensResponseSchema: Schema<CustomerVaultPaymentTokensResponse> = object(
  {
    totalItems: ['total_items', optional(number())],
    totalPages: ['total_pages', optional(number())],
    customer: ['customer', optional(lazy(() => vaultResponseCustomerSchema))],
    paymentTokens: [
      'payment_tokens',
      optional(array(lazy(() => paymentTokenResponseSchema))),
    ],
    links: ['links', optional(array(lazy(() => linkDescriptionSchema)))],
  }
);
