/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { lazy, object, optional, Schema, string } from '../schema';
import { AssuranceDetails, assuranceDetailsSchema } from './assuranceDetails';
import {
  GooglePayDecryptedTokenData,
  googlePayDecryptedTokenDataSchema,
} from './googlePayDecryptedTokenData';
import {
  GooglePayExperienceContext,
  googlePayExperienceContextSchema,
} from './googlePayExperienceContext';
import {
  GooglePayRequestCard,
  googlePayRequestCardSchema,
} from './googlePayRequestCard';
import {
  PhoneNumberWithCountryCode,
  phoneNumberWithCountryCodeSchema,
} from './phoneNumberWithCountryCode';

/** Information needed to pay using Google Pay. */
export interface GooglePayRequest {
  /** The full name representation like Mr J Smith. */
  name?: string;
  /** The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters are allowed after the @ sign. However, the generally accepted maximum length for an email address is 254 characters. The pattern verifies that an unquoted @ sign exists. */
  emailAddress?: string;
  /** The phone number in its canonical international [E.164 numbering plan format](https://www.itu.int/rec/T-REC-E.164/en). */
  phoneNumber?: PhoneNumberWithCountryCode;
  /** The payment card used to fund a Google Pay payment. Can be a credit or debit card. */
  card?: GooglePayRequestCard;
  /** Details shared by Google for the merchant to be shared with PayPal. This is required to process the transaction using the Google Pay payment method. */
  decryptedToken?: GooglePayDecryptedTokenData;
  /** Information about cardholder possession validation and cardholder identification and verifications (ID&V). */
  assuranceDetails?: AssuranceDetails;
  /** Customizes the payer experience during the approval process for the payment. */
  experienceContext?: GooglePayExperienceContext;
}

export const googlePayRequestSchema: Schema<GooglePayRequest> = object({
  name: ['name', optional(string())],
  emailAddress: ['email_address', optional(string())],
  phoneNumber: [
    'phone_number',
    optional(lazy(() => phoneNumberWithCountryCodeSchema)),
  ],
  card: ['card', optional(lazy(() => googlePayRequestCardSchema))],
  decryptedToken: [
    'decrypted_token',
    optional(lazy(() => googlePayDecryptedTokenDataSchema)),
  ],
  assuranceDetails: [
    'assurance_details',
    optional(lazy(() => assuranceDetailsSchema)),
  ],
  experienceContext: [
    'experience_context',
    optional(lazy(() => googlePayExperienceContextSchema)),
  ],
});
