/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { lazy, object, optional, Schema } from '../schema';
import { ExchangeRate, exchangeRateSchema } from './exchangeRate';
import { Money, moneySchema } from './money';

/** The net amount. Returned when the currency of the refund is different from the currency of the PayPal account where the merchant holds their funds. */
export interface NetAmountBreakdownItem {
  /** The currency and amount for a financial transaction, such as a balance or payment due. */
  payableAmount?: Money;
  /** The currency and amount for a financial transaction, such as a balance or payment due. */
  convertedAmount?: Money;
  /** The exchange rate that determines the amount to convert from one currency to another currency. */
  exchangeRate?: ExchangeRate;
}

export const netAmountBreakdownItemSchema: Schema<NetAmountBreakdownItem> = object(
  {
    payableAmount: ['payable_amount', optional(lazy(() => moneySchema))],
    convertedAmount: ['converted_amount', optional(lazy(() => moneySchema))],
    exchangeRate: ['exchange_rate', optional(lazy(() => exchangeRateSchema))],
  }
);
