/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { lazy, object, optional, Schema, string } from '../schema';
import { Money, moneySchema } from './money';
import { ShippingType, shippingTypeSchema } from './shippingType';

/** The options that the payee or merchant offers to the payer to ship or pick up their items. */
export interface OrderUpdateCallbackShippingOption {
  /** A unique ID that identifies a payer-selected shipping option. */
  id: string;
  /** A description that the payer sees, which helps them choose an appropriate shipping option. For example, `Free Shipping`, `USPS Priority Shipping`, `Expédition prioritaire USPS`, or `USPS yōuxiān fā huò`. Localize this description to the payer's locale. */
  label: string;
  /** A classification for the method of purchase fulfillment. */
  type?: ShippingType;
  /** The currency and amount for a financial transaction, such as a balance or payment due. */
  amount?: Money;
}

export const orderUpdateCallbackShippingOptionSchema: Schema<OrderUpdateCallbackShippingOption> = object(
  {
    id: ['id', string()],
    label: ['label', string()],
    type: ['type', optional(shippingTypeSchema)],
    amount: ['amount', optional(lazy(() => moneySchema))],
  }
);
