/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { lazy, object, optional, Schema } from '../schema';
import {
  ApplePayPaymentObject,
  applePayPaymentObjectSchema,
} from './applePayPaymentObject';
import {
  BancontactPaymentObject,
  bancontactPaymentObjectSchema,
} from './bancontactPaymentObject';
import {
  BlikPaymentObject,
  blikPaymentObjectSchema,
} from './blikPaymentObject';
import { CardResponse, cardResponseSchema } from './cardResponse';
import { EpsPaymentObject, epsPaymentObjectSchema } from './epsPaymentObject';
import {
  GiropayPaymentObject,
  giropayPaymentObjectSchema,
} from './giropayPaymentObject';
import {
  GooglePayWalletResponse,
  googlePayWalletResponseSchema,
} from './googlePayWalletResponse';
import {
  IdealPaymentObject,
  idealPaymentObjectSchema,
} from './idealPaymentObject';
import {
  MybankPaymentObject,
  mybankPaymentObjectSchema,
} from './mybankPaymentObject';
import { P24PaymentObject, p24PaymentObjectSchema } from './p24PaymentObject';
import {
  PaypalWalletResponse,
  paypalWalletResponseSchema,
} from './paypalWalletResponse';
import {
  SofortPaymentObject,
  sofortPaymentObjectSchema,
} from './sofortPaymentObject';
import {
  TrustlyPaymentObject,
  trustlyPaymentObjectSchema,
} from './trustlyPaymentObject';
import {
  VenmoWalletResponse,
  venmoWalletResponseSchema,
} from './venmoWalletResponse';

/** The payment source used to fund the payment. */
export interface PaymentSourceResponse {
  /** The payment card to use to fund a payment. Card can be a credit or debit card. */
  card?: CardResponse;
  /** The PayPal Wallet response. */
  paypal?: PaypalWalletResponse;
  /** Information used to pay Bancontact. */
  bancontact?: BancontactPaymentObject;
  /** Information used to pay using BLIK. */
  blik?: BlikPaymentObject;
  /** Information used to pay using eps. */
  eps?: EpsPaymentObject;
  /** Information needed to pay using giropay. */
  giropay?: GiropayPaymentObject;
  /** Information used to pay using iDEAL. */
  ideal?: IdealPaymentObject;
  /** Information used to pay using MyBank. */
  mybank?: MybankPaymentObject;
  /** Information used to pay using P24(Przelewy24). */
  p24?: P24PaymentObject;
  /** Information used to pay using Sofort. */
  sofort?: SofortPaymentObject;
  /** Information needed to pay using Trustly. */
  trustly?: TrustlyPaymentObject;
  /** Information needed to pay using ApplePay. */
  applePay?: ApplePayPaymentObject;
  /** Google Pay Wallet payment data. */
  googlePay?: GooglePayWalletResponse;
  /** Venmo wallet response. */
  venmo?: VenmoWalletResponse;
}

export const paymentSourceResponseSchema: Schema<PaymentSourceResponse> = object(
  {
    card: ['card', optional(lazy(() => cardResponseSchema))],
    paypal: ['paypal', optional(lazy(() => paypalWalletResponseSchema))],
    bancontact: [
      'bancontact',
      optional(lazy(() => bancontactPaymentObjectSchema)),
    ],
    blik: ['blik', optional(lazy(() => blikPaymentObjectSchema))],
    eps: ['eps', optional(lazy(() => epsPaymentObjectSchema))],
    giropay: ['giropay', optional(lazy(() => giropayPaymentObjectSchema))],
    ideal: ['ideal', optional(lazy(() => idealPaymentObjectSchema))],
    mybank: ['mybank', optional(lazy(() => mybankPaymentObjectSchema))],
    p24: ['p24', optional(lazy(() => p24PaymentObjectSchema))],
    sofort: ['sofort', optional(lazy(() => sofortPaymentObjectSchema))],
    trustly: ['trustly', optional(lazy(() => trustlyPaymentObjectSchema))],
    applePay: ['apple_pay', optional(lazy(() => applePayPaymentObjectSchema))],
    googlePay: [
      'google_pay',
      optional(lazy(() => googlePayWalletResponseSchema)),
    ],
    venmo: ['venmo', optional(lazy(() => venmoWalletResponseSchema))],
  }
);
