/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { lazy, object, optional, Schema } from '../schema';
import { Customer, customerSchema } from './customer';
import {
  PaymentTokenRequestPaymentSource,
  paymentTokenRequestPaymentSourceSchema,
} from './paymentTokenRequestPaymentSource';

/** Payment Token Request where the `source` defines the type of instrument to be stored. */
export interface PaymentTokenRequest {
  /** This object defines a customer in your system. Use it to manage customer profiles, save payment methods and contact details. */
  customer?: Customer;
  /** The payment method to vault with the instrument details. */
  paymentSource: PaymentTokenRequestPaymentSource;
}

export const paymentTokenRequestSchema: Schema<PaymentTokenRequest> = object({
  customer: ['customer', optional(lazy(() => customerSchema))],
  paymentSource: [
    'payment_source',
    lazy(() => paymentTokenRequestPaymentSourceSchema),
  ],
});
