/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, object, optional, Schema, string } from '../schema';
import { CustomerResponse, customerResponseSchema } from './customerResponse';
import { LinkDescription, linkDescriptionSchema } from './linkDescription';
import {
  PaymentTokenResponsePaymentSource,
  paymentTokenResponsePaymentSourceSchema,
} from './paymentTokenResponsePaymentSource';

/** Full representation of a saved payment token. */
export interface PaymentTokenResponse {
  /** The PayPal-generated ID for the vault token. */
  id?: string;
  /** Customer in merchant's or partner's system of records. */
  customer?: CustomerResponse;
  /** The vaulted payment method details. */
  paymentSource?: PaymentTokenResponsePaymentSource;
  /** An array of related [HATEOAS links](/api/rest/responses/#hateoas). */
  links?: LinkDescription[];
}

export const paymentTokenResponseSchema: Schema<PaymentTokenResponse> = object({
  id: ['id', optional(string())],
  customer: ['customer', optional(lazy(() => customerResponseSchema))],
  paymentSource: [
    'payment_source',
    optional(lazy(() => paymentTokenResponsePaymentSourceSchema)),
  ],
  links: ['links', optional(array(lazy(() => linkDescriptionSchema)))],
});
