/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { boolean, lazy, object, optional, Schema, string } from '../schema';
import { Address, addressSchema } from './address';
import { Name, nameSchema } from './name';
import {
  PaypalPaymentTokenCustomerType,
  paypalPaymentTokenCustomerTypeSchema,
} from './paypalPaymentTokenCustomerType';
import {
  PaypalPaymentTokenUsageType,
  paypalPaymentTokenUsageTypeSchema,
} from './paypalPaymentTokenUsageType';
import { Phone, phoneSchema } from './phone';
import { PhoneWithType, phoneWithTypeSchema } from './phoneWithType';
import { UsagePattern, usagePatternSchema } from './usagePattern';
import {
  VaultedDigitalWalletShippingDetails,
  vaultedDigitalWalletShippingDetailsSchema,
} from './vaultedDigitalWalletShippingDetails';

export interface PaypalPaymentToken {
  /** The description displayed to the consumer on the approval flow for a digital wallet, as well as on the merchant view of the payment token management experience. exp: PayPal.com. */
  description?: string;
  /** Expected business/charge model for the billing agreement. */
  usagePattern?: UsagePattern;
  /** The shipping details. */
  shipping?: VaultedDigitalWalletShippingDetails;
  /** Create multiple payment tokens for the same payer, merchant/platform combination. Use this when the customer has not logged in at merchant/platform. The payment token thus generated, can then also be used to create the customer account at merchant/platform. Use this also when multiple payment tokens are required for the same payer, different customer at merchant/platform. This helps to identify customers distinctly even though they may share the same PayPal account. This only applies to PayPal payment source. */
  permitMultiplePaymentTokens?: boolean;
  /** The usage type associated with a digital wallet payment token. */
  usageType?: PaypalPaymentTokenUsageType;
  /** The customer type associated with a digital wallet payment token. This is to indicate whether the customer acting on the merchant / platform is either a business or a consumer. */
  customerType?: PaypalPaymentTokenCustomerType;
  /** The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters are allowed after the @ sign. However, the generally accepted maximum length for an email address is 254 characters. The pattern verifies that an unquoted @ sign exists. */
  emailAddress?: string;
  /** The account identifier for a PayPal account. */
  payerId?: string;
  /** The name of the party. */
  name?: Name;
  /** The phone information. */
  phone?: PhoneWithType;
  /** The portable international postal address. Maps to [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling form controls: the autocomplete attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute). */
  address?: Address;
  /** The account identifier for a PayPal account. */
  accountId?: string;
  /** The phone number, in its canonical international [E.164 numbering plan format](https://www.itu.int/rec/T-REC-E.164/en). */
  phoneNumber?: Phone;
}

export const paypalPaymentTokenSchema: Schema<PaypalPaymentToken> = object({
  description: ['description', optional(string())],
  usagePattern: ['usage_pattern', optional(usagePatternSchema)],
  shipping: [
    'shipping',
    optional(lazy(() => vaultedDigitalWalletShippingDetailsSchema)),
  ],
  permitMultiplePaymentTokens: [
    'permit_multiple_payment_tokens',
    optional(boolean()),
  ],
  usageType: ['usage_type', optional(paypalPaymentTokenUsageTypeSchema)],
  customerType: [
    'customer_type',
    optional(paypalPaymentTokenCustomerTypeSchema),
  ],
  emailAddress: ['email_address', optional(string())],
  payerId: ['payer_id', optional(string())],
  name: ['name', optional(lazy(() => nameSchema))],
  phone: ['phone', optional(lazy(() => phoneWithTypeSchema))],
  address: ['address', optional(lazy(() => addressSchema))],
  accountId: ['account_id', optional(string())],
  phoneNumber: ['phone_number', optional(lazy(() => phoneSchema))],
});
