/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, object, optional, Schema, string } from '../schema';
import { LinkDescription, linkDescriptionSchema } from './linkDescription';
import {
  PaypalWalletCustomer,
  paypalWalletCustomerSchema,
} from './paypalWalletCustomer';
import {
  PaypalWalletVaultStatus,
  paypalWalletVaultStatusSchema,
} from './paypalWalletVaultStatus';

/** The details about a saved PayPal Wallet payment source. */
export interface PaypalWalletVaultResponse {
  /** The PayPal-generated ID for the saved payment source. */
  id?: string;
  /** The vault status. */
  status?: PaypalWalletVaultStatus;
  /** An array of request-related HATEOAS links. */
  links?: LinkDescription[];
  /** The details about a customer in PayPal's system of record. */
  customer?: PaypalWalletCustomer;
}

export const paypalWalletVaultResponseSchema: Schema<PaypalWalletVaultResponse> = object(
  {
    id: ['id', optional(string())],
    status: ['status', optional(paypalWalletVaultStatusSchema)],
    links: ['links', optional(array(lazy(() => linkDescriptionSchema)))],
    customer: ['customer', optional(lazy(() => paypalWalletCustomerSchema))],
  }
);
