/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, object, optional, Schema } from '../schema';
import { Money, moneySchema } from './money';
import {
  NetAmountBreakdownItem,
  netAmountBreakdownItemSchema,
} from './netAmountBreakdownItem';
import { PlatformFee, platformFeeSchema } from './platformFee';

/** The breakdown of the refund. */
export interface SellerPayableBreakdown {
  /** The currency and amount for a financial transaction, such as a balance or payment due. */
  grossAmount?: Money;
  /** The currency and amount for a financial transaction, such as a balance or payment due. */
  paypalFee?: Money;
  /** The currency and amount for a financial transaction, such as a balance or payment due. */
  paypalFeeInReceivableCurrency?: Money;
  /** The currency and amount for a financial transaction, such as a balance or payment due. */
  netAmount?: Money;
  /** The currency and amount for a financial transaction, such as a balance or payment due. */
  netAmountInReceivableCurrency?: Money;
  /** An array of platform or partner fees, commissions, or brokerage fees for the refund. */
  platformFees?: PlatformFee[];
  /** An array of breakdown values for the net amount. Returned when the currency of the refund is different from the currency of the PayPal account where the payee holds their funds. */
  netAmountBreakdown?: NetAmountBreakdownItem[];
  /** The currency and amount for a financial transaction, such as a balance or payment due. */
  totalRefundedAmount?: Money;
}

export const sellerPayableBreakdownSchema: Schema<SellerPayableBreakdown> = object(
  {
    grossAmount: ['gross_amount', optional(lazy(() => moneySchema))],
    paypalFee: ['paypal_fee', optional(lazy(() => moneySchema))],
    paypalFeeInReceivableCurrency: [
      'paypal_fee_in_receivable_currency',
      optional(lazy(() => moneySchema)),
    ],
    netAmount: ['net_amount', optional(lazy(() => moneySchema))],
    netAmountInReceivableCurrency: [
      'net_amount_in_receivable_currency',
      optional(lazy(() => moneySchema)),
    ],
    platformFees: [
      'platform_fees',
      optional(array(lazy(() => platformFeeSchema))),
    ],
    netAmountBreakdown: [
      'net_amount_breakdown',
      optional(array(lazy(() => netAmountBreakdownItemSchema))),
    ],
    totalRefundedAmount: [
      'total_refunded_amount',
      optional(lazy(() => moneySchema)),
    ],
  }
);
