/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, object, optional, Schema, string } from '../schema';
import { Customer, customerSchema } from './customer';
import { LinkDescription, linkDescriptionSchema } from './linkDescription';
import {
  PaymentTokenStatus,
  paymentTokenStatusSchema,
} from './paymentTokenStatus';
import {
  SetupTokenResponsePaymentSource,
  setupTokenResponsePaymentSourceSchema,
} from './setupTokenResponsePaymentSource';

/** Minimal representation of a cached setup token. */
export interface SetupTokenResponse {
  /** The PayPal-generated ID for the vault token. */
  id?: string;
  /** This object defines a customer in your system. Use it to manage customer profiles, save payment methods and contact details. */
  customer?: Customer;
  /** The status of the payment token. */
  status?: PaymentTokenStatus;
  /** The setup payment method details. */
  paymentSource?: SetupTokenResponsePaymentSource;
  /** An array of related [HATEOAS links](/api/rest/responses/#hateoas). */
  links?: LinkDescription[];
}

export const setupTokenResponseSchema: Schema<SetupTokenResponse> = object({
  id: ['id', optional(string())],
  customer: ['customer', optional(lazy(() => customerSchema))],
  status: ['status', optional(paymentTokenStatusSchema)],
  paymentSource: [
    'payment_source',
    optional(lazy(() => setupTokenResponsePaymentSourceSchema)),
  ],
  links: ['links', optional(array(lazy(() => linkDescriptionSchema)))],
});
