/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, object, optional, Schema, string } from '../schema';
import { Address, addressSchema } from './address';
import { FulfillmentType, fulfillmentTypeSchema } from './fulfillmentType';
import {
  OrderTrackerResponse,
  orderTrackerResponseSchema,
} from './orderTrackerResponse';
import {
  PhoneNumberWithCountryCode,
  phoneNumberWithCountryCodeSchema,
} from './phoneNumberWithCountryCode';
import { ShippingName, shippingNameSchema } from './shippingName';
import { ShippingOption, shippingOptionSchema } from './shippingOption';

/** The order shipping details. */
export interface ShippingWithTrackingDetails {
  /** The name of the party. */
  name?: ShippingName;
  /** The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters are allowed after the @ sign. However, the generally accepted maximum length for an email address is 254 characters. The pattern verifies that an unquoted @ sign exists. */
  emailAddress?: string;
  /** The phone number in its canonical international [E.164 numbering plan format](https://www.itu.int/rec/T-REC-E.164/en). */
  phoneNumber?: PhoneNumberWithCountryCode;
  /** A classification for the method of purchase fulfillment (e.g shipping, in-store pickup, etc). Either `type` or `options` may be present, but not both. */
  type?: FulfillmentType;
  /** An array of shipping options that the payee or merchant offers to the payer to ship or pick up their items. */
  options?: ShippingOption[];
  /** The portable international postal address. Maps to [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling form controls: the autocomplete attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute). */
  address?: Address;
  /** An array of trackers for a transaction. */
  trackers?: OrderTrackerResponse[];
}

export const shippingWithTrackingDetailsSchema: Schema<ShippingWithTrackingDetails> = object(
  {
    name: ['name', optional(lazy(() => shippingNameSchema))],
    emailAddress: ['email_address', optional(string())],
    phoneNumber: [
      'phone_number',
      optional(lazy(() => phoneNumberWithCountryCodeSchema)),
    ],
    type: ['type', optional(fulfillmentTypeSchema)],
    options: ['options', optional(array(lazy(() => shippingOptionSchema)))],
    address: ['address', optional(lazy(() => addressSchema))],
    trackers: [
      'trackers',
      optional(array(lazy(() => orderTrackerResponseSchema))),
    ],
  }
);
