/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { object, optional, Schema, string } from '../schema';
import { EnrollmentStatus, enrollmentStatusSchema } from './enrollmentStatus';
import { PaResStatus, paResStatusSchema } from './paResStatus';

/** Results of 3D Secure Authentication. */
export interface ThreeDSecureCardAuthenticationResponse {
  /** Transactions status result identifier. The outcome of the issuer's authentication. */
  authenticationStatus?: PaResStatus;
  /** Status of Authentication eligibility. */
  enrollmentStatus?: EnrollmentStatus;
  /** The externally received 3ds authentication id, to be returned in card detokenization response. */
  authenticationId?: string;
}

export const threeDSecureCardAuthenticationResponseSchema: Schema<ThreeDSecureCardAuthenticationResponse> = object(
  {
    authenticationStatus: [
      'authentication_status',
      optional(paResStatusSchema),
    ],
    enrollmentStatus: ['enrollment_status', optional(enrollmentStatusSchema)],
    authenticationId: ['authentication_id', optional(string())],
  }
);
